# THIS procedure gets the selected packages and installs them
                                                                                
package provide AutoUpdate 1.0
                                                                                
proc AUpkgProvide { W } {
   global env auANS EnVSeL SySCmDs

# THIS is the selected package information

   set PkGs [split [$W curselection] ]
   set pLen [llength $PkGs]
   
# LOOP over the selections
                                                                                
   for { set I 0 } { $I < $pLen } { incr I } {

# GET the information on the selected line

      set sN [lindex $PkGs $I]
      set pLiNe [$W get $sN ] 
      scan $pLiNe "%10s%14s%11s%11s" pName pElement iRev pRev

      set piD [lindex $auANS(pID) [lsearch $auANS(PKGS) $pName]]
      set pdB [lindex $auANS(PDBS) [lsearch $auANS(pID) $piD]]

# REQUEST the package

      AUgetPkg $pElement $pRev $pdB

# UNTAR the delivered file to get the Package and its database entry.

      set bName $pElement.$pRev
      if ![file exists $bName.tar] { continue }
      exec $SySCmDs(tar) -xf $bName.tar 
      if [file exists $bName.tar] { file delete -force $bName.tar }

# INTEGRETY check.  Make sure we have both the files we expected.  If not
#   delete any we did get an continue.

      if { ![file exists $bName.dbe] || ![file exists $bName.tgz] } {
         if [file exists $bName.dbe] { file delete -force $bName.dbe }
         if [file exists $bName.tgz] { file delete -force $bName.tgz }
         continue
      }

# READ the database entry.  We need to see if there are any dependencies, 
#    and install any that need to be installed.

      if [AUreadPdB $bName pI 1] {
         if [info exists pI(DEP)] {
            set DepPkgs [split $pI(DEP) "+"]
            set NoPkg [llength $DepPkgs]
            for { set J 0 } { $J < $NoPkg } { incr J } {
               set InS [AUdepCheck $DepPkgs $J]
               if { [llength $InS] > 0 } { AUdepInstall $InS }
            }     
         }
      } else {
         if [file exists $bName.dbe] { file delete -force $bName.dbe }
         continue
      }

# CHECK for existance of all required environment variables and install the
#   package if they are all set

      if [AUcheckEnv pI] {
          if [info exists pI(SCMD)] {
             eval $pI(SCMD) pI
          } else { AUpkgInstall pI }
          AUinstUpdate $W $sN $pLiNe pI
      }
   }
}
