# THIS procedure installs any dependent packages needed to be installed prior
#   to installing a selected package
                                                                                
package provide AutoUpdate 1.0
                                                                                
proc AUdepInstall { InSPkG } {
   global env SySCmDs auANS

   set Status 1

   set pE [lindex $InSPkG 0]
   set pN [lindex $InSPkG 1]
   set pR [lindex $InSPkG 2]

   switch -exact -- $pE {
      UDFCORE -
      GPHCORE  { AUcoreInstall $pE }
      default  {
         set pD [lindex $auANS(PDBS) [lsearch $auANS(PKGS) $pN]]
         AUgetPkg $pE $pR $pD

# UNTAR the delivered file to get the Package and its database entry.

         set bName $pE.$pR
         if ![file exists $bName.tar] { set Status 0 ; continue }

# GET the actual package revision number if revision is LATEST and rename
#   the package to include it correct revision number

         if [string match $pR LATEST] {
            catch { exec $SySCmDs(tar) -tf $bName.tar } OuT
	    scan $OuT "%s" PkG
	    set Parts [split $PkG "."]
	    set pR [lindex $Parts 1].[lindex $Parts 2]
	    set bName $pE.$pR
            file rename -force $pE.LATEST.tar $bName.tar
	 }

# UNTAR the delivered file to get the Package and its database entry.

         exec $SySCmDs(tar) -xf $bName.tar 
         if [file exists $bName.tar] { file delete -force $bName.tar }

# INTEGRETY check.  Make sure we have both the files we expected.  If not
#   delete any we did get an continue.

         if { ![file exists $bName.dbe] || ![file exists $bName.tgz] } {
            if [file exists $bName.dbe] { file delete -force $bName.dbe }
            if [file exists $bName.tgz] { file delete -force $bName.tgz }
            set Status 0
            continue
         }

# READ the database entry.  We need to see if there are any dependencies, 
#   and install any that need to be installed.  
#
# NOTE that this is a recursive call.  Hopefully we never get into any
#   infinite loops!

         if [AUreadPdB $bName pI 1] {
            if [info exists pI(DEP)] {
               set DepPkgs [split $pI(DEP) "+"]
               set NoPkg [llength $DepPkgs]
               for { set J 0 } { $J < $NoPkg } { incr J } {
                  set InS [AUdepCheck $DepPkgs $J]
                  if { [llength $InS] > 0 } { AUdepInstall $InS }
	       }     
            }
         } else {
            if [file exists $bName.dbe] { file delete -force $bName.dbe }
            continue
         }

# CHECK for existance of all required environment variables and install the
#   the package if they are all set

         if [AUcheckEnv pI] { 
            if [info exists pI(SCMD)] {
               eval $pI(SCMD) pI
            } else { AUpkgInstall pI }

            set dbN [array names pI]
            set pP [lsearch $dbN DEP]
            if { $pP < 0 } { set DeP  "" } else { set DeP $pI(DEP) }
            set pP [lsearch $dbN RCMP]
            if { $pP < 0 } { set CmP  "" } else { set CmP $pI(RCMP) }

            set pP [lsearch $auANS(ipkg,$pD) $pE]
            if { $pP < 0 } {
               lappend auANS(ipkg,$pD) $pE
               lappend auANS(irev,$pD) $pR
               lappend auANS(idep,$pD) $DeP 
               lappend auANS(icmp,$pD) $CmP 
            } else {
               set auANS(irev,$pD) [lreplace $auANS(irev,$pD) $pP $pP $pR] 
               set auANS(idep,$pD) [lreplace $auANS(idep,$pD) $pP $pP $DeP]
               set auANS(icmp,$pD) [lreplace $auANS(icmp,$pD) $pP $pP $CmP] 
            }
         } else { set Status 0 } 
      }
   }

   return $Status
}
