# THIS procedure gets the selected packages and installs them
                                                                                
package provide AutoUpdate 1.0
                                                                                
proc AUcoreInstall { CorE } {
   global env auANS EnVSeL SySCmDs

# THIS is the list of packages to install

   switch -exact -- $CorE {
      UDFCORE { 
         set cPkg $auANS(UDFPKG) 
	 set pName UDF
	 set HOME $env(UDF_HOME)
	 AUdirCntrl $HOME [list lib INSTALLED bin ] REMOVESUB
	 AUdirCntrl $HOME [list lib INSTALLED bin ] CREATE
      }
      GPHCORE { 
         set cPkg $auANS(GPHPKG) 
	 lappend cPkg GMAPS
	 set pName GPH
	 set HOME $env(GPH_HOME)
	 AUdirCntrl $HOME [list lib INSTALLED ] REMOVESUB
	 AUdirCntrl $HOME [list lib drivers INSTALLED] CREATE
      }
   }
   set pdB [lindex $auANS(PDBS) [lsearch $auANS(PKGS) $pName]]

# LOOP over the packages

   set pLen [llength $cPkg] 
   for { set I 0 } { $I < $pLen } { incr I } {

# GET the package name

      set pElement [lindex $cPkg $I]

# REQUEST the package

      AUgetPkg $pElement LATEST $pdB

# UNTAR the delivered file to get the Package and its database entry.

      set tName $pElement.LATEST
      if ![file exists $tName.tar] { continue }

# GET the actual package revision number ... LATEST just won't cut it.

      catch { exec $SySCmDs(tar) -tf $tName.tar } OuT 
      scan $OuT "%s" PkG
      set Parts [split $PkG "."]
      set pRev [lindex $Parts 1].[lindex $Parts 2]
      set bName $pElement.$pRev

# RENAME the package and get the entries

      file rename -force $tName.tar $bName.tar

      exec $SySCmDs(tar) -xf $bName.tar 
      if [file exists $bName.tar] { file delete -force $bName.tar }

# INTEGRETY check.  Make sure we have both the files we expected.  If not
#   delete any we did get and continue.

      if { ![file exists $bName.dbe] || ![file exists $bName.tgz] } {
         if [file exists $bName.dbe] { file delete -force $bName.dbe }
         if [file exists $bName.tgz] { file delete -force $bName.tgz }
         continue
      }

# READ the database entry.  This has where is package needs to be put
#   as well as its install options and dependencies

      if ![AUreadPdB $bName pI 1] { continue }

# CHECK for existance of all required environment variables and install the
#   package if they are all set

      if [AUcheckEnv pI] {
         if [info exists pI(SCMD)] {
            eval $pI(SCMD) pI
         } else { AUpkgInstall pI }

         set dbN [array names pI]
         set pP [lsearch $dbN DEP]
         if { $pP < 0 } { set DeP  "" } else { set DeP $pI(DEP) }
         set pP [lsearch $dbN RCMP]
         if { $pP < 0 } { set CmP  "" } else { set CmP $pI(RCMP) }

         set pP [lsearch $auANS(ipkg,$pdB) $pElement]
         if { $pP < 0 } {
            lappend auANS(ipkg,$pdB) $pElement
            lappend auANS(irev,$pdB) $pRev
            lappend auANS(idep,$pdB) $DeP 
            lappend auANS(icmp,$pdB) $CmP 
         } else {
            set auANS(irev,$pdB) [lreplace $auANS(irev,$pdB) $pP $pP $pRev] 
            set auANS(idep,$pdB) [lreplace $auANS(idep,$pdB) $pP $pP $DeP] 
            set auANS(icmp,$pdB) [lreplace $auANS(icmp,$pdB) $pP $pP $CmP] 
         }
      }
   }
}

