# THIS procedure checks that the required environment variables are set.
                                                                                
package provide AutoUpdate 1.0
                                                                                
proc AUcheckEnv { dBEntries } {
   global env auANS EnVSeT SySCmDs

   upvar $dBEntries pI

# CHECK for existance of all required environment variables

   set Status 1
   if [info exists pI(ENV)] {
      set eNvar [split $pI(ENV) "+"]
      set envLen [llength $eNvar]
      for { set J 0 } { $J < $envLen } { incr J } {
         set ComP [split [lindex $eNvar $J] ","]
         set nC [llength $ComP]
               
         if { $nC != 1 } {
            if {[string compare L [lindex $ComP 0]] != 0 } { set nC 1 }
         } else { set nC 1 }

         if { $nC == 1 } {
            set vName [lindex $eNvar $J]
            if ![info exists env($vName)] {
               AUenvSet $pI(PKG) $vName
               vwait EnVSeT
               unset EnVSeT
               if ![info exists env($vName)] { set Status 0 }
            }
         } else {
            set vName [lindex $ComP 1]
            if ![info exists auANS($vName)] { set Status 0 }
         }
      }
   }
   return $Status
}
