package provide TclUtils_C 1.0

proc TUvecMath { A Action B C { Xa 0} { Xb 0} { X 0 } { LenA 3 } { LenB 3 } } {
   global PI RtoD

   upvar $A V
   upvar $B W
   upvar $C R
    
   set T 0.0
   switch -exact -- $Action {
      CROSS {  
         set Ya [expr $Xa + 1]
         set Za [expr $Xa + 2]
         set Yb [expr $Xb + 1]
         set Zb [expr $Xb + 2]
         set R($X) [expr $V($Ya) * $W($Zb) - $V($Za) * $W($Yb)] ; incr X
         set R($X) [expr $V($Za) * $W($Xb) - $V($Xa) * $W($Zb)] ; incr X
         set R($X) [expr $V($Xa) * $W($Yb) - $V($Ya) * $W($Xb)] 
      }

      DOT   {  
         for { set I 0 } { $I < $LenA } { incr I ; incr Xa ; incr Xb } {
            set T [expr $T + $V($Xa) * $W($Xb)]
         }
      }

      MAG   {  
         for { set I 0 } { $I < $LenA } { incr I ; incr Xa } {
            set T [expr $T + $V($Xa) * $V($Xa)]
         }
         set T [expr sqrt($T)]
      }

      UNIT  { 
         set Xt $Xa
         for { set I 0 } { $I < $LenA } { incr I ; incr Xa } {
            set T [expr $T + $V($Xa) * $V($Xa)]
         }
         set T [expr sqrt($T)]
	 if { $T != 0.0 } {
            for { set I 0 } { $I < $LenA } { incr I ; incr Xt ; incr X } {
               set R($X) [expr $V($Xt) / $T]
            }
         }
      }

      TENSOR   {  
         set EnD [expr $LenB + $Xb]
         set Base [expr $Xb - ($Xb % $LenB)]
         for { set I 0 } { $I < $LenA } { incr I ; incr Xa } {
            for { set J $Xb } { $J < $EnD } { incr J ; incr X } {
               set K [expr $Base + $J % $LenB ]
               set R($X) [expr $V($Xa) * $W($K) ] 
            }
         }
      }

      default {   
         if [string match R* $Action] {
            set Action [string index $Action 1]
            set Base [expr $Xb - ($Xb % $LenB)]
            for { set I 0 } { $I < $LenA } { incr I ; incr Xa ; incr X } {
               set J [expr $Base + ($I + $Xb) % $LenB ]
               set R($X) [expr $V($Xa) $Action $W($J)]
            }
         } else {
            for { set I 0 } { $I < $LenA } { incr I ; incr Xa ; incr X } {
               set J [expr $Xb + $I % $LenB ]
               set R($X) [expr $V($Xa) $Action $W($J)]
            }
         } 
      }
   }

   return $T
}
