package provide TclUtils 1.0 

#  TIME format returns time input as Yr Day Msec NSec in various formats
#     according to format.  The time is returned as a list.

#   FORMAT               INPUT                             OUTPUT
# ---------   -----------------------------    ------------------------------
#     0        Yr Dy T1=Msec                     Yr Day HH:MM:SS.MSEC
#     1        Yr Dy T1=Msec T2=Nsec             Yr Day HH MM SS NSEC 
#     2        Yr Dy T1=Msec                     YrDayHHMMSS
#     3        Yr Dy T1=Msec                     YrDayHHMM
#     4        Yr Dy                             YrMoDy
#     5        Yr Mo Dy                          YrDay


proc TUtimeFmt { FmT Yr { Dy 1 } { T1 0 } { T2 0 } { T3 0 } { T4 0 } 
                        { T5 0 } { T6 0 } } {

# MAKE sure that there are no leading 0's in any of the input data

   set Yr [TUdataNoOctal $Yr 1]
   set Dy [TUdataNoOctal $Dy 1]
   set T1 [TUdataNoOctal $T1 ]
   set T2 [TUdataNoOctal $T2 ]
   set T3 [TUdataNoOctal $T3 ]
   set T4 [TUdataNoOctal $T4 ]
   set T5 [TUdataNoOctal $T5 ]
   set T6 [TUdataNoOctal $T6 ]

   switch -exact -- $FmT {
     0  {  set Hr [expr $T1 / 3600000 ]
           set Mn [expr ($T1 % 3600000) / 60000 ]
           set Sc [expr ($T1 % 60000) / 1000 ]
           set Ms [expr $T1 % 1000]
           set ReT [format "%i %03i %02i:%02i:%02i.%03i" \
                                                $Yr $Dy $Hr $Mn $Sc $Ms]
        }
     1  {  set Hr [expr $T1 / 3600000 ]
           set Mn [expr ($T1 % 3600000) / 60000 ]
           set Sc [expr ($T1 % 60000) / 1000 ]
           set Ns [expr int(($T1 % 1000) * 1e6 + $T2)]
           set ReT [format "%i %i %i %i %i %i" $Yr $Dy $Hr $Mn $Sc $Ns]
        }
     2  {  set Hr [expr $T1 / 3600000 ]
           set Mn [expr ($T1 % 3600000) / 60000 ]
           set Sc [expr ($T1 % 60000) / 1000 ]
           set ReT [format "%i%03i%02i%02i%02i" $Yr $Dy $Hr $Mn $Sc]
        }
     3  {  set Hr [expr $T1 / 3600000 ]
           set Mn [expr ($T1 % 3600000) / 60000 ]
           set ReT [format "%i%03i%02i%02i" $Yr $Dy $Hr $Mn]
        }
     4  {  if { [TUyearLeap $Yr] == 366 } { 
              set dM [list 31 29 31 30 31 30 31 31 30 31 30 31]
           } else { set dM [list 31 28 31 30 31 30 31 31 31 31 30 31] }
           set Mo 0
           while { $Dy > 0 } {
              set lDy $Dy
              set Dy [expr $Dy - [lindex $dM $Mo]]
              incr Mo
           }
           set ReT [format "%d%02d%02d" $Yr $Mo $lDy]
        }
     5  {  if { [TUyearLeap $Yr] == 366 } { 
              set dM [list 0 31 60 91 121 152 182 213 244 274 305 335]
           } else { set dM [list 0 31 59 90 120 151 181 212 243 273 304 334] }
	   incr Dy -1
           set Dy [expr $T1 + [lindex $dM $Dy]]
           set ReT [format "%d%03d" $Yr $Dy]
        }
   }

   return $ReT
}
