#
#  TUtimeConv - Convert Time to Difference from Base Time 
#               Convert Time Difference to Absolute Time
#
#  INPUT:  bT      - Base time [list]
#          cT      - Conversion Time [list] or time difference
#          Action  - 
#             0:  Difference
#             1:  Absolute in time format 0
#             2:  Absolute in time format 1
#             3:  Absolute in time format 2
#          Base    - base time for difference or base time of difference
#            -1:  No base - best base will be determined
#             0:  Decimal days
#             1:  Decimal seconds
#             2:  Nanoseconds
#
#  TIME FORMATS :   Format 0  Index 0: Year
#                             Index 1: Day or decimal day
#                             Index 2: Hour 
#                             Index 3: Minute
#                             Index 4: Second
#                             Index 5: Nanosecond
#
#                   Format 1  Index 0: Year
#                             Index 1: Day 
#                             Index 2: Millisecond 
#                             Index 3: Nanosecond
#
#                   Format 2  Index 0: Year
#                             Index 1: Day or decimal day
#                             Index 2: Hour 
#                             Index 3: Minute
#                             Index 4: Second
#                             Index 5: Millisecond
#                             Index 6: Microsecond
#                             Index 7: Nanosecond
#
#  OUTPUT: Returned time in units of decimal Base or a list of uncompressed 
#          time components

package provide TclUtils 1.0

proc TUtimeConv { bT cT Action Base } {

   upvar $Base B

   set bY [lindex $bT 0]
   set bD [lindex $bT 1]
   set FmT [llength $bT ]

# Determine a good time base to use for two separated times if no valid
# base has been specified 
#

   if { $Action == 0 } {
      set yR [lindex $cT 0]
      set dY [lindex $cT 1]
      set dT(1) 0 
      set BegY [expr $bY + 1]
      for { set I $BegY } { $I < $yR } { incr I } { incr dT(1) [TUyearLeap $I] }
      if { $yR > $bY } {
         set dT(1) [expr $dT(1) + [TUyearLeap $bY] + $dY - $bD]
      } else { set dT(1) [expr $dT(1) + $dY - $bD] }

#     set dT(1) [expr $dT(1) + [lindex $cT 1] - [lindex $bT 1]]
#     for { set I $bY } { $I < $yR } { incr I } { incr dD [TUyearLeap $I] }
#     set dT(1) [expr $dT(1) + [lindex $cT 1] - [lindex $bT 1]]
#
      for { set I 2 } { $I < $FmT } { incr I } {
          set dT($I) [expr [lindex $cT $I] - [lindex $bT $I]]
      }

      switch -exact -- $FmT {
         4  {  if {$dT(3) < 0} { incr dT(3) 1000000 ; incr dT(2) -1     }
               if {$dT(2) < 0} { incr dT(2) 86400000 ; incr dT(1) -1    }
               set sS [expr int($dT(2) / 1000.0)]
               set nS [expr ($dT(2) % 1000) * 1000000 + $dT(3)]
            }
         6  {  if {$dT(5) < 0} { incr dT(5) 1000000000 ; incr dT(4) -1  }
               if {$dT(4) < 0} { incr dT(4) 60 ; incr dT(3) -1          }
               if {$dT(3) < 0} { incr dT(3) 60 ; incr dT(2) -1          }
               if {$dT(2) < 0} { incr dT(2) 24 ; incr dT(1) -1          }
               set sS [expr $dT(2) * 3600 + $dT(3) * 60 + $dT(4)]
               set nS $dT(5)
            }
         8  {  if {$dT(7) < 0} { incr dT(7) 1000 ; incr dT(6) -1        }
               if {$dT(6) < 0} { incr dT(6) 1000 ; incr dT(5) -1        }
               if {$dT(5) < 0} { incr dT(5) 1000 ; incr dT(4) -1        }
               if {$dT(4) < 0} { incr dT(4) 60 ; incr dT(3) -1          }
               if {$dT(3) < 0} { incr dT(3) 60 ; incr dT(2) -1          }
               if {$dT(2) < 0} { incr dT(2) 24 ; incr dT(1) -1          }
               set sS [expr $dT(2) * 3600 + $dT(3) * 60 + $dT(4)]
               set nS [expr $dT(5) * 1000000 + $dT(6) * 1000 + $dT(7)]
            }
      }

      if {$B == -1 } {
         if { $dT(1) > 0 } {
            set B 0
         } elseif { $sS > 0 } {
            set B 1
         } else { set B 2 }
      }

      if {$B == 0 } {
         set ReT [expr $dT(1) + ($sS + $nS * 1.0e-9) / 86400.0]
      } elseif { $B == 1 } {
         set ReT [expr $dT(1) * 86400.0 + $sS + $nS * 1.0e-9]
      } else {
         set ReT [expr $dT(1) * 8.64e13 + $sS * 1.0e9 + $nS]
      }
   } else {

# NEED to check if the input time is less than zero. We need to approach this
#   case a little bit differently than positive time

      if { $cT < 0.0 } {
         set cT [expr -$cT]
	 set SgN -1
      } else { set SgN 1 }

      set Whole [expr int($cT)]
      set PoS [string first "." $cT]
      if { $PoS >= 0 } { 
          set Frac [string range $cT $PoS end] 
      } else { set Frac Whole }

#     set Frac  [lindex [split $cT "."] 1]
#     set Frac  [expr mod(int($cT*1000000000), 1000000000)]
#     set Frac  [expr int($cT*1000000000) % 1000000000]

      switch -exact -- $B {
         0  {  set dY [expr $SgN * $Whole]
               set sS [expr $SgN * $Frac * 86400.0]
               set nS [expr $SgN * fmod($sS, 1.0) * 1000000000]
            }
         1  {  set dY [expr $SgN * $Whole / 86400.0]
               set sS [expr $SgN * ($Whole % 86400)]
               set nS [expr $SgN * int($Frac * 1000000000)]
            }
         2  {  set dY [expr $SgN * $Whole / 8.64e13]
               set sS [expr $SgN * fmod($dY, 1.0) * 86400.0]
               set nS [expr $SgN * ($Whole % 1000000000)]
            }
      }

      switch -exact -- $FmT  {
         4  {  set Ms [lindex $bT 2] 
               set sS [expr int($Ms  / 1000.0) + $sS]
               set nS [expr ($Ms % 1000) * 1000000 + [lindex $bT 3] + $nS]
            }
         6  {  set sS [expr [lindex $bT 2] * 3600 + [lindex $bT 3] * 60 \
                          + [lindex $bT 4] + $sS]
               set nS [expr [lindex $bT 5] + $nS]
            }
         8  {  set sS [expr [lindex $bT 2] * 3600 + [lindex $bT 3] * 60 \
                          + [lindex $bT 4] + $sS]
               set nS [expr [lindex $bT 5] * 1000000 + [lindex $bT 6] * 1000 \
                          + [lindex $bT 7] + $nS]
            }
      }

# AT this point we need to get all of the quantities to be postive. 
#   Negative values can come from negative input times.

      if { $nS < 0.0 } {
         set sS [expr $sS - 1] 
         set nS [expr 1.0e9 + $nS]
      }
      if { $sS < 0.0 } {
         set dY [expr $dY - 1] 
         set nS [expr 86400.0 + $sS]
      }

      set dY [expr int($dY)]
      set sS [expr int($sS)]
      set nS [expr int(ceil($nS))]

# HERE is where the correction for a dY <= 0 occurs

      set dY [expr $bD + $dY]
      if { $dY <= 0 } {
         set yR [expr $bY - 1]
         set dY [expr [TUyearLeap $yR] - $dY]
      } else { set yR $bY }

      set DiY [TUyearLeap $yR]
      while { $dY > $DiY } {
         set dY [expr $dY - $DiY]
         incr yR 
         set DiY [TUyearLeap $yR]
      }

      set sS [expr $sS + int($nS / 1000000000)]
      set nS [expr $nS % 1000000000]
      set dY [expr $dY + int($sS / 86400)]
      set sS [expr $sS % 86400]

      set dD [TUyearLeap $yR] 
      while {$dY > $dD } {
         set dY [expr $dY - $dD]
         incr $yR
         set dD [TUyearLeap $yR] 
      }

      switch -exact -- $Action {
         1  {  set Hr [expr int($sS / 3600.0)]
               set Mn [expr int(($sS % 3600) / 60) ]
               set Ss [expr int($sS % 60) ]
               set ReT [list $yR $dY $Hr $Mn $Ss $nS ] 
            }
         2  {  set Ms [expr $sS * 1000 + int($nS / 1000000.0)]
               set Ns [expr $nS % 1000000]
               set ReT [list $yR $dY $Ms $Ns ] 
            }
         3  {  set Hr [expr int($sS / 3600.0) ]
               set Mn [expr int(($sS % 3600) / 60) ]
               set Ss [expr $sS % 60 ]
               set Ms [expr int($nS / 1000000.0 ) ]
               set Us [expr int(($nS % 1000000 ) / 1000.0) ]
               set Ns [expr int($nS % 1000 ) ]
               set ReT [list $yR $dY $Hr $Mn $Ss $Ms $Us $Ns ]
            }
      }
   }

   return $ReT 
}
