package provide TclUtils 1.0 

#  TIME format compares the two input times and returns 1 if the first time
#    is greater than the second, 0 if they are identical, and -1 if the first
#    time is less than the second time.  Times can be input in various
#    formats with the restriction that the formats be identical for
#    both times
#
#  TIMES can be entered as lists or as individual variables.  The routine
#     checks

#   FORMAT               INPUT               
# ---------   -----------------------------  
#     0        Yr Dy Msec                 
#     1        Yr Dy Msec Nsec         
#     2        Yr Dy
#     3        Yr Dy Hr
#     4        Yr Dy Hr Mn
#     5        Yr Dy Hr Mn Sec
#     6        Yr Dy Hr Mn Sec Msec 
#     7        Yr Dy Hr Mn Sec Msec NSec 


proc TUtimeCmp { FmT T1 T2 {T3 0} {T4 0} {T5 0} {T6 0} {T7 0} {T8 0} \
                           {T9 0} {T10 0} {T11 0} {T12 0} {T13 0} {T14 0} } {

   set lLen [llength $T1]
   if { $lLen > 1 } {
      set TmP1 $T1
      set TmP2 $T2
      set J 1
      for { set I 0 } { $I < $lLen } { incr I } {
          set T$J [lindex $TmP1 $I]
          incr J
      }  
      for { set I 0 } { $I < $lLen } { incr I } {
          set T$J [lindex $TmP2 $I]
          incr J
      }  
   } 

   switch -exact -- $FmT {
      0  {  set tA [format "%4d%03d%08d" $T1 $T2 $T3]
            set tB [format "%4d%03d%08d" $T4 $T5 $T6]
         }
      1  {  set tA [format "%4d%03d%08d%06d" $T1 $T2 $T3 $T4]
            set tB [format "%4d%03d%08d%06d" $T4 $T6 $T7 $T8]
         }
      2  {  set tA [format "%4d%03d" $T1 $T2]
            set tB [format "%4d%03d" $T3 $T4]
         }
      3  {  set mSa [expr $T3 * 3600000] 
            set mSb [expr $T6 * 3600000] 
            set tA [format "%4d%03d%08d" $T1 $T2 $mSa]
            set tB [format "%4d%03d%08d" $T4 $T5 $mSb]
         }
      4  {  set mSa [expr $T3 * 3600000 + $T4 * 60000] 
            set mSb [expr $T7 * 3600000 + $T8 * 60000] 
            set tA [format "%4d%03d%08d" $T1 $T2 $mSa]
            set tB [format "%4d%03d%08d" $T5 $T6 $mSb]
         }
      5  {  set mSa [expr $T3 * 3600000 + $T4 * 60000 + $T5 * 1000] 
            set mSb [expr $T8 * 3600000 + $T9 * 60000 + $T10 * 1000] 
            set tA [format "%4d%03d%08d" $T1 $T2 $mSa]
            set tB [format "%4d%03d%08d" $T6 $T7 $mSb]
         }
      6  {  set mSa [expr $T3 * 3600000 + $T4 * 60000 + $T5 * 1000 + $T6] 
            set mSb [expr $T9 * 3600000 + $T10 * 60000 + $T11 * 1000 + $T12] 
            set tA [format "%4d%03d%08d" $T1 $T2 $mSa]
            set tB [format "%4d%03d%08d" $T7 $T8 $mSb]
         }
      7  {  set mSa [expr $T3 * 3600000 + $T4 * 60000 + $T5 * 1000 + $T6] 
            set mSb [expr $T10 * 3600000 + $T11 * 60000 + $T12 * 1000 + $T13] 
            set tA [format "%4d%03d%08d%06d" $T1 $T2 $mSa $T7]
            set tB [format "%4d%03d%08d%06d" $T8 $T9 $mSb $T14]
         }
   }

   if [string match $tA $tB]  {
      set rV 0
   } else { 
      set tList [lsort -ascii -increasing [list $tA $tB]]
      set rV [expr 2 * [lsearch $tList $tA] - 1]
   }

   return $rV
}
