# Find solutions to Cubic equation of the form
#    Ax^3 + Bx^2 + Cx + D = 0
#
#  MANUAL PAGE
#     Generated

package provide TclUtils_C 1.0

proc TUsolveCubic { A B C D } {
   global TwoPI

#  REDUCE TO  x^3 + ax^2 + bx + c = 0

   set a [expr $B/$A] 
   set b [expr $C/$A] 
   set c [expr $D/$A] 

   set Q [expr ($a * $a - 3.0 * $b) / 9.0]
   set R [expr (2.0 * $a * $a * $a - 9.0 * $a * $b + 27.0 * $c) / 54.0]
   
   set Q3 [expr $Q * $Q * $Q]
   set R2 [expr $R * $R]

   if { $R2 < $Q3 } {

# THREE real roots

       set Ang [expr acos($R / sqrt($Q3))]
       set sQ  [expr -2.0 * sqrt($Q)]
       set rA  [expr $a / 3.0]

       set r1 [expr $sQ * cos($Ang/3.0) - $rA]
       set r2 [expr $sQ * cos(($Ang + $TwoPI) / 3.0) - $rA]
       set r3 [expr $sQ * cos(($Ang - $TwoPI) / 3.0) - $rA]
       set rV [list $r1 $r2 $r3]
       set rV [lsort -real -increasing $rV ]
   } else {
       if {$R < 0.0 } { set SgN -1.0 } else { set SgN 1.0 }
       set A [expr abs($R) + sqrt($R * $R - $Q3)]
       set A [expr -$SgN * exp(log(abs($A))/3.0)]
       if {$A == 0.0 } { set B 0.0 } else { set B [expr $Q / $A] }
       set r1 [expr $A + $B - $a/3.0]
       set r2 [expr -($A + $B)/2.0 - $a/3.0]
       set r3 [expr -($A + $B)/2.0 - $a/3.0]
       if { $A != $B } {
          set i2 [expr sqrt(3.0) * ($A - $B) / 2.0]
          set i3 [expr -sqrt(3.0) * ($A - $B) / 2.0]
          set rV [list $r1 $r2 $r3 $i2 $i3]
       } else { set rV [list $r1 $r2 $r3] }
   }

   return $rV
}
