#
#  Procedure
#     Return Z which is the result of a 3D polynomial expansion of the form
#       z = a[0] + a[1]*x + a[2]*y + a[3]*x**2 + a[4]*xy + a[5]*y**2 + .....
#
#  usage
#      set Z  [TUpolyExp1D X Y nOrder nCoef Coef]
#
#  parameter description
#     X        X value
#     Y        Y value
#     Z        Resultant Z value
#     nCoef    number of coefficients
#     Coef     array of coefficients of polynomial
#

package provide TclUtils 1.0

proc TUpolyExp3D { X Y Z  nCoef Coef nOrder { Offset 0 } { uLim 0 } { lLim 0 } } {

   upvar $Coef A

# ZERO out the array which will hold the variable portion of the polynomial

   for { set I 0 } { $I < $nCoef } { incr I } { set vA($I) 0.0 }

# FILL in the variable portion of the polynomial

   set Base 0
   set LenX 1
   set LenY 1
   set dX 2
   set vA(0) 1.0
   set L 1

   for { set J 0 } { $J < $nOrder } { incr J } {
      set M $Base
      for { set K 0 } { $K < $LenX } { incr K } {
         set vA($L) [expr $vA($M) * $X]
         incr L
         incr M
      }

      incr M [expr -$dX + 1]
      for { set K 0 } { $K < $LenY } { incr K } {
         set vA($L) [expr $vA($M) * $Y]
         incr L
         incr M
      }

      incr M -1
      set vA($L) [expr $vA($M) * $Z]
      incr L

      incr Base $LenX
      incr LenX $dX
      incr LenY 
      incr dX
   }

   set V 0.0
   set I $Offset
   for { set J 0 } { $J < $nCoef } { incr I ; incr J  } { 
      set V [expr $V + $A($I) * $vA($J)] 
   }

   if { $uLim != $lLim } {
      if { $V > $uLim } { set V $uLim }
      if { $V < $lLim } { set V $lLim }
   }
       
   return $V
}
