#  Procedure
#     Return Z which is the result of a polynomial expansion of the form
#       z = a[0] + a[1]*x + a[2]*y + a[3]*x**2 + a[4]*xy + a[5]*y**2 + .....
#
#  usage
#      set Z  [TUpolyExp2D X Y nCoef Coef nOrder]
#
#  INPUTS
#     X        X value
#     nCoef    number of coefficients
#     Coef     array of coefficients of polynomial
#     nOrder   order of polynomial
#     Offset   offset into the coefficient array
#     uLim     upper limit clamp
#     lLim     lower limit clamp
#
#  OUTPUT
#     Resultant Value
#
#  MANUAL PAGE
#     Generated

package provide TclUtils_C 1.0

proc TUpolyExp2D { X Y  nCoef Coef nOrder { Offset 0 } { uLim 0 } { lLim 0 } } {

   upvar $Coef A

   set Base 0
   set LenX 1
   set TmpXY(0) 1.0
   set L 1
   for { set J 0 } { $J < $nOrder } { incr J } {
      set M $Base
      for { set K 0 } { $K < $LenX } { incr K } {
         set TmpXY($L) [expr $TmpXY($M) * $X] 
         incr L
         incr M
      }
      incr M -1
      set TmpXY($L) [expr $TmpXY($M) * $Y]
      incr L
      incr Base $LenX
      incr LenX
   }

   set Z 0.0
   set I $Offset
   for { set J 0 } { $J < $nCoef } { incr I ; incr J  } { 
      set Z [expr $Z + $A($I) * $TmpXY($J)] 
   }

   if { $uLim != $lLim } {
      if { $Z > $uLim } { set Z $uLim }
      if { $Z < $lLim } { set Z $lLim }
   }
       
   return $Z
}
