#  Procedure
#     Return Y which is the result of a polynomial expansion of the form
#       y = a[0] + a[1]*x + a[2]*x**2 + a[3]*x**3 + .....
#
#  usage
#      set Y  [TUpolyExp1D X nCoef Coef]
#
#  INPUTS
#     X        X value
#     nCoef    number of coefficients
#     Coef     array of coefficients of polynomial
#     Offset   offset into the coefficient array
#     uLim     upper limit clamp     
#     lLim     lower limit clamp
#
#  OUTPUT
#     Resultant Value
#
#  MANUAL PAGE
#     Generated

package provide TclUtils_C 1.0

proc TUpolyExp1D { X nCoef Coef { Offset 0 } { uLim 0 } { lLim 0 } } {

   upvar $Coef A

   set K $Offset
   set EnD [expr $Offset + $nCoef]
   set PoW 1.0
   set Y $A($K) ; incr K
   for { set I $K } { $I < $EnD } { incr I } { 
      set PoW [expr $PoW * $X]
      set Y [expr $Y + $A($I) * $PoW] 
   }

   if { $uLim != $lLim } {
      if { $Y > $uLim } { set Y $uLim }
      if { $Y < $lLim } { set Y $lLim }
   }

   return $Y
}
