# GENERIC procedure to return the bases functions for a 3D polynomial
#   This is taylored for use in TUdataLSq3D

package provide TclUtils 1.0

proc TUpoly3DFunc { X Y Z cM nO nC } {
   upvar $cM A

# IF the number of coefficients associated with this order of polynomial
#   hasn't been computed yet do it now

   if { $nC <= 0 } {
      set nC 1;
      for { set I 1 ; set J 2 } { $I <= $nO } {  } {
         set nC [expr $nC + $I + $J]
         incr I
	 incr J $I
      }
   }

# COMPUTE the basis functions

   set A(0) 1.0

   set BaseX 0
   set BaseY 0
   set BaseZ 0
   set CuR  1
   set LenX 1

   for { set I 1 } { $I <= $nO } { incr I } {
      set nBase $CuR
      for { set J 0 } { $J < $LenX } { incr J ; incr CuR } {
         set A($CuR) [expr $A($BaseX) * $X]
	 incr BaseX
      }

      for { set J 0 } { $J < $I } { incr J ; incr CuR } {
         set A($CuR) [expr $A($BaseY) * $Y]
	 incr BaseY
      }

      set A($CuR) [expr $A($BaseZ) * $Z]
      incr CuR

      set BaseX $nBase
      set LenX [expr $LenX + $I + 1]
      set BaseY [expr $BaseX + $LenX - $I - 1]
      set BaseZ [expr $BaseX + $LenX - 1]
   }

   return $nC
}
