# GENERIC procedure to return the bases functions for a 2D polynomial
#   This is taylored for use in TUdataLSq1D

package provide TclUtils 1.0

proc TUpoly2DFunc { X Y cM nO nC } {
   upvar $cM A

# IF the number of coefficients associated with this order of polynomial
#   hasn't been computed yet do it now

   if { $nC <= 0 } {
      set nC 1;
      for { set I 1 } { $I <= $nO } { incr I } {
         set nC [expr $nC + $I + 1]
      }
   }

# COMPUTE the basis functions

   set A(0) 1.0

   set Base 0
   set LenX 1
   set L 1
   for { set J 0 } { $J < $nO } { incr J } {
      set M $Base
      for { set K 0 } { $K < $LenX } { incr K } {
         set A($L) [expr $A($M) * $X]
         incr L
         incr M
      }
      incr M -1
      set A($L) [expr $A($M) * $Y]
      incr L
      incr Base $LenX
      incr LenX
   }

   return $nC
}
