#
#  This routines solves the set of linear equations MX=V where A is the
#  LU decomposition of the matrix M obtained from a call to TUmatrixLUD.
#  N is the matrix order, Index is the permutation vector output by
#  TUmatrixLUD, and V is the solution vector.
#  

#  NOTE:  matrix data is assumed linear, laid down row by row.

package provide TclUtils 1.0

proc TUmatrixLUSub {Matrix N Index Vector } {

   upvar $Matrix A
   upvar $Index  In
   upvar $Vector V

   set nZ -1
   set LastN [ expr $N - 1 ]

   for { set I 0 } { $I <= $LastN } { incr I } { 
      set iP  $In($I)
      set Sum $V($iP)
      set V($iP) $V($I)
      if { $nZ < 0 } {
          if { $Sum != 0.0 } { set nZ $I }
      } else {
          set EnD [expr $I - 1]
          set P [expr $I * $N + $nZ]
          for { set J $nZ } { $J <= $EnD } { incr J ; incr P } { 
             set Sum [expr $Sum - $A($P) * $V($J)]
          }
      } 
      set V($I) $Sum
   }

   for { set I $LastN } { $I >= 0 } { incr I -1 } { 
      set Sum $V($I)
      set BeG [expr $I + 1]
      set P [expr $I * $N + $BeG]
      for { set J $BeG } { $J <= $LastN } { incr J ; incr P } { 
          set Sum [expr $Sum - $A($P) * $V($J)]
      }
      set P [expr $I * $N + $I]
      set V($I) [expr $Sum / $A($P)]
   }
}
