#  LU Matrix decomposition 
#
#  Given a square matrix A (NxN) this procedure replaces it with the LU
#  decomposition of a row-wise permutation of itself.  Index is an output
#  vector that records the row permutation effected by the partial pivoting.
#  The routine returns +1 or -1 depending on whether the number of 
#  permutations was even or odd respectively.  Routine returns 0 for error.

#  NOTE:  matrix data is assumed linear, laid down row by row.

package provide TclUtils 1.0

proc TUmatrixLUD {Matrix N Index } {

   upvar $Matrix A
   upvar $Index  In

   set D 1
   set LastN [ expr $N - 1 ]

#  Loop over the rows to get scaling information.

   set P 0
   for { set I 0 } { $I <= $LastN } { incr I } { 
      set BiG 0.0 
      for { set J 0 } { $J <= $LastN } { incr J ; incr P } { 
          set Tmp [expr abs($A($P))]
          if { $Tmp > $BiG } { set BiG $Tmp } 
      }
      if { $BiG == 0.0 } {
         puts stderr "TUmatrixLUD: Singular matrix"
         return 0
      }
      set V($I) [expr 1.0 / $BiG]
   }

   for { set J 0 } { $J <= $LastN } { incr J } { 
      set P $J
      for { set I 0 } { $I < $J } { incr I ; incr P $N } { 
         set Sum $A($P)
         set P1 [expr $I * $N]
         set P2 $J
         for { set K 0 } { $K < $I } { incr K ; incr P1; incr P2 $N } { 
            set Sum [expr $Sum - $A($P1) * $A($P2)]
         }
         set A($P) $Sum
      }

      set BiG 0.0 
      set P [expr $J * $N + $J]
      for { set I $J } { $I <= $LastN } { incr I ; incr P $N } { 
         set Sum $A($P)
         set P1 [expr $I * $N]
         set P2 $J
         for { set K 0 } { $K < $J } { incr K ; incr P1; incr P2 $N } { 
            set Sum [expr $Sum - $A($P1) * $A($P2)]
         }
         set A($P) $Sum
         set Tmp [expr $V($I) * abs($Sum)]
         if { $Tmp >= $BiG } { set BiG $Tmp ; set iMax $I } 
      }

      if { $J != $iMax } {
         set P1 [expr $iMax * $N]
         set P2 [expr $J * $N]
         for { set K 0 } { $K <= $LastN } { incr K ; incr P1 ; incr P2 } {
            set Tmp $A($P1)
            set A($P1) $A($P2)
            set A($P2) $Tmp
         }
         set D [expr -$D] 
         set V($iMax) $V($J)
      }

      set In($J) $iMax
      set P [expr $J * $N + $J]
      if { $A($P) == 0.0 } { set A($P) 1.0e-20 }
      if { $J != $LastN } {
          set Tmp [expr 1.0 / $A($P)]
          set BeG [expr $J + 1 ]
          set P [expr $BeG * $N + $J]
          for { set I $BeG } { $I <= $LastN } { incr I ; incr P $N } { 
            set A($P) [expr $A($P) * $Tmp]
          }
      }
   }

   return $D
}
