#  Matrix Inversion using Guass-Jordian elimination

package provide TclUtils_C 1.0

proc TUmatrixInv { N Mat1 { B1 0 } { M 0 } { Mat2 0} { B2 0 } } {

   upvar $Mat1 A

   if { $M > 0 } { upvar $Mat2 B }

   for { set J 0 } { $J < $N } { incr J } { set iPiv($J) 0 }

   for { set I 0 } { $I < $N } { incr I } { 
      set BiG 0.0
      for { set J 0 } { $J < $N } { incr J } { 
         if { $iPiv($J) != 1 } {
            set P [expr $B1 + $N * $J]
            for { set K 0 } { $K < $N } { incr K ; incr P } { 
               if { $iPiv($K) == 0 } {
                  set aB [expr abs($A($P))]
                  if { $aB >= $BiG } {
                      set BiG $aB
                      set iR $J
                      set iC $K
                  }
               } elseif { $iPiv($K) > 1 } { return -1 }
            }
         }
      }
      incr iPiv($iC)
      if { $iC != $iR } {
         set P1 [expr $B1 + $N * $iR]
         set P2 [expr $B1 + $N * $iC]
         for { set L 0 } { $L < $N } { incr L ; incr P1 ; incr P2 } {
             TUdataSwap A($P1) A($P2)
         }
         set P1 [expr $B2 + $M * $iR]
         set P2 [expr $B2 + $M * $iC]
         for { set L 0 } { $L < $M } { incr L ; incr P1 ; incr P2 } {
             TUdataSwap B($P1) B($P2)
         }
      }
      set indxr($I) $iR
      set indxc($I) $iC
      set P [expr $N * $iC + $iC + $B1]
      if { $A($P) == 0.0 } { return -2 }
      set pivInv [expr 1.0 / $A($P)]
      set A($P) 1.0
      set P [expr $B1 + $N * $iC]
      for { set L 0 } { $L < $N } { incr L ; incr P } {
         set A($P) [ expr $A($P) * $pivInv]
      }
      set P [expr $B2 + $M * $iC]
      for { set L 0 } { $L < $M } { incr L ; incr P } {
         set B($P) [ expr $B($P) * $pivInv]
      }
      for { set Q 0 } { $Q < $N } { incr Q } {
         if { $Q != $iC } {
             set P [expr $B1 + $N * $Q + $iC]
             set T $A($P)
             set A($P) 0.0
             set P [expr $B1 + $N * $Q]
             set P1 [expr $B1 + $N * $iC]
             for { set L 0 } { $L < $N } { incr L ; incr P ; incr P1 } {
                set A($P) [ expr $A($P) - $A($P1) * $T]
             }
             set P [expr $B2 + $M * $Q]
             set P1 [expr $B2 + $M * $iC]
             for { set L 0 } { $L < $M } { incr L ; incr P ; incr P1 } {
                set B($P) [ expr $B($P) - $B($P1) * $T]
             }
         } 
      }
   }

   for { set L [expr $N - 1] } { $L >= 0 } { incr L -1 } {
      if { $indxr($L) != $indxc($L) } {
         for { set K 0 } { $K < $N } { incr K } {
             set P [expr $B1 + $N * $K + $indxr($L)]
             set P1 [expr $B1 + $N * $K + $indxc($L)]
             TUdataSwap A($P1) A($P)
         }
      }
   }

   return 1
}
