package provide TclUtils 1.0

#  Given a square matrix A (NxN) this procedure computes the determinent.
#
#  NOTE:  matrix data is assumed linear, laid down row by row.
#
# A      - Matrix Input
# N      - Rows or Columns in Matrix A

proc TUmatrixDet { A N } {

   upvar $A X

# SINCE LUD overwrites the input matrix - save it so that its not destroyed

   set ToT [expr $N * $N]
   for { set I 0 } { $I < $ToT } { incr I } { set DuP($I) $X($I) }

# DECOMPOSE matrix

   set T [expr double([TUmatrixLUD DuP $N Index])]

# FORM determinent 
   
   set dS [expr $N + 1]
   for { set I 0 } { $I < $ToT } { incr I $dS } { set T [expr $T * $DuP($I)] }

   return $T
}
