#  Complex Matrix Inversion
 
# N is number or rows or columns
# rA is real input 
# iA is imaginary input 
# rB is the real inverted matrix
# iB is the real imaginary matrix
#
# The inversion will be checked with the diagonals begin 1 within the given 
#    accuracy V.  If dV is non-zero then if the accuracy isn't met the 
#    diagonal elements will be randomally shifted by dV times the minimum 
#    element value and the inversion re-donw
#
# V accuracy for inversion
# dV increment column value
#
# Returns 0: Can't Invert
#         1: Successful inversion
 
package provide TclUtils 1.0

proc TUmatrixCInv {N rA iA rB iB {V 1.0e-5 } {dV 0.01}} {

   upvar $rA rMi
   upvar $iA iMi
   upvar $rB rMo
   upvar $iB iMo

# TOTAL values in matrix and skip to get from diagonal to diagonal

   set nN [expr 2 * $N]
   set tV [expr $nN * $nN]
   set dS [expr $nN + 1]
 
# BUILD combined matrix

   set oS 0
   set BeG [expr $nN * $N]
   for { set I 0 } { $I < $N } { incr I ; incr oS $N } {
      set rKt [expr $I * $nN]
      set iKt [expr $rKt + $N]
      set rKb [expr $BeG + $I * $nN]
      set iKb [expr $rKb + $N]
      for { set J 0 } { $J < $N } { incr J } {
         set C($rKt) $rMi([expr $oS + $J]) ; incr rKt
         set C($iKt) $iMi([expr $oS + $J]) ; incr iKt
         set C($rKb) [expr -$iMi([expr $oS + $J])] ; incr rKb
         set C($iKb) $rMi([expr $oS + $J]) ; incr iKb
      }
   }

# SAVE matrix to be inverted
 
   for { set I 0 } { $I < $tV } { incr I } { set mT($I) $C($I) }
       
# TRY inversion and make sure that the inverted matrix times the original 
#    has ones along the diagonal.
 
   set Stat [TUmatrixInv $nN C]

# CHECK the inversion

   set Stat [TUmatrixMath mT * C TmP $nN $nN $nN $nN]

   set rV 1
   set I 0
   while { $rV && ($I < $tV) } {
      set dD [expr abs(1.0 - $TmP($I))] 
      if { $dD > $V } { set rV 0 }
      incr I $dS
   }

# IF the matrix didn't invert and dV > 0.0 then shift the diagonal values 
#     a bit and redo 
 
   if { ($dV > 0.0) && !$rV } {

# RESET the matrix to be inverted
 
      for { set I 0 } { $I < $tV } { incr I } { set C($I) $mT($I)  }

# FIND the minimum diagonal value and determine offset
 
      set tVa [expr $N * $N] 
      set dSa [expr $N + 1] 

      set mD 1.0e50
      for { set I 0 } { $I < $tV } { incr I $dS  } { 
         if { $C($I) < $mD } { set mD $C($I) }
      }
      if { $mD == 0.0 } { set mD 1.0 }
      set oV [expr abs($mD * $V)]

      set tVh [expr $nN * $N]
      for { set I 0 ; set J 0 } { $I < $tVh } { incr I $dS ; incr J $dSa } { 
         set sH [TUdataRnd1 TmP 1 P $oV]
         set C($I) [expr $C($I) + $sH] 
         set mT($I) [expr $mT($I) + $sH] 
         set rMi($J) [expr $rMi($J) + $sH]
         set K [expr $I + $tVh + $N]
         set C($K) [expr $C($K) + $sH] 
         set mT($K) [expr $mT($K) + $sH] 
      }

      set rV [TUmatrixInv $nN C]
      set rV [TUmatrixMath mT * C TmP $nN $nN $nN $nN]

      set rV 1
      set I 0
      while { $rV && ($I < $tV) } {
         set dD [expr abs(1.0 - $TmP($I))] 
         if { $dD > $V } { set rV 0 }
         incr I $dS
      }
   }

# RECOVER the real and imaginary of the inverted matrix

   set K 0 
   set oS 0
   for { set I 0 } { $I < $N } { incr I ; incr oS $nN } {
      for { set J 0 } { $J < $N } { incr J ; incr K } {
         set rMo($K) $C([expr $oS + $J])
      }
   }

   set K 0 
   set oS $N
   for { set I 0 } { $I < $N } { incr I ; incr oS $nN } {
      for { set J 0 } { $J < $N } { incr J ; incr K } {
         set iMo($K) $C([expr $oS + $J])
      }
   }

   return $rV
}
