#
#  Procedure
#    perform a trapazoidal integration over the function given by 
#          y = F($X)
#
#  usage
#      set Value [TUintegTrap FunC Beg End N ]
#
#  parameter description
#     FunC     the function which determines intensity for a given X
#     Beg      start integration value
#     End      end integration value
#     N        Number of points added since last call to integral: 2**(N-2)
#     pV       privious integration used for interative calls
#     OneTime  indicates if all the terms used in the integration are 
#              computed and returned in a single call to FunCNamE or 
#              you get one value per call. 

package provide TclUtils_C 1.0

proc TUintegTrap { FunCNamE Beg End N { pV 0.0 } { OneTime 0 } } {

# INTEGRATION interval

   set dH [expr $End - $Beg]

# CHECK for illegal N

   if { $N < 1 } { set N 1 }

#  TRIVIAL CASE 

   if { $OneTime == 1 } {
      set TmP { $Beg $dh $J -1 OuT }
      set FunC "set fOut \[$FunCNamE $TmP\]"
      if { $N == 1 } {
          set dh $dH
          set J 2 
          eval $FunC
          set Sum 0.0
          for { set I 0 } { $I < $J } { incr I } { 
              set Sum [expr $Sum + $OuT($I)]
          }
          set rV [expr 0.5 * $dH  * $Sum];
      } else {
          set M [expr $N - 1] 
          set J 1
          for { set I 0 } { $I < $M } { incr I } { set J [expr $J << 1] } 
          set TnM [expr double($J)]
          set dh [expr $dH / $TnM]
          set Beg [expr $Beg + 0.5 * $dh]
          eval $FunC
          set Sum 0.0
          for { set I 0 } { $I < $J } { incr I } { 
              set Sum [expr $Sum + $OuT($I)]
          }
          set rV [expr 0.5 * ($pV + $dH  * $Sum / $TnM)];
      }
   } else {
      set TmP { $Beg $dh $J $I }
      set FunC "set fOut \[$FunCNamE $TmP\]"
      if { $N == 1 } {
          set dh $dH
          set J 2 
          set Sum 0.0
          for { set I 0 } { $I < $J } { incr I ; set Beg [expr $Beg + $dH] } { 
              eval $FunC
              set Sum [expr $Sum + $fOut]
          }
          set rV [expr 0.5 * $dH  * $Sum];
      } else {
          set M [expr $N - 1] 
          set J 1
          for { set I 0 } { $I < $M } { incr I } { set J [expr $J << 1] } 
          set TnM [expr double($J)]
          set dh [expr $dH / $TnM]
          set Beg [expr $Beg + 0.5 * $dh]
          set Sum 0.0
          for { set I 0 } { $I < $J } { incr I ; set Beg [expr $Beg + $dh] } { 
              eval $FunC
              set Sum [expr $Sum + $fOut]
          }
          set rV [expr 0.5 * ($pV + $dH  * $Sum / $TnM)];
      }
   }

   return $rV
}
