#  gInFo - Grid Information
#          0:  Beginning X grid position 
#          1:  Ending X grid position 
#          2:  Beginning Y grid position 
#          3:  Ending Y grid position 
#          4:  Number of grids along X
#          5:  Number of grids along Y
#          6:  User POINT or BAND method to store X data
#          7:  User POINT or BAND method to store Y data
#          8:  Storage Method ROW or COLUMN
#          9:  IGNORE or KEEP Zeros when averaging 
#         10:  NEW and ADD (initialize) or ADD ( just add to) grid or  
#              ADDEND  ADD (add to and normalize) grid or END   
#         11:  Value to set unfilled grids to
#         12:  Bad grid value 
#         13:  Remove data below this value
#         14:  Remove data above this value
#         15:  Cyclic in X
#         16:  Cyclic in Y
#

#  INPUTS
#    CmD   :  REGRID (Trim and regrid)
#          :  REGRIDX (Trim and regrid only in X)
#          :  REGRIDY (Trim and regrid only in Y)
#          :  EDGES  (Gives the edges back only)
#    Grid  :  The data grid
#    GridN :  The data grid normalization 
#    gInfo :  The data grid definition parameters
#    oPs   :  0 - Trim is maximum intensity in a row or column is less than
#                 or equal to this value
#          :  0 - Return absolute edges
#          :  1 - Return distance from edges
                 

package provide TclUtils 1.0

proc TUgridTrim { CmD Grid GridN gInFo sOp } {
 
   upvar $Grid G
   upvar $GridN N
   upvar $gInFo gI
   upvar $sOp oP

# TOTAL number of grid rows and columns as last values

   set nC [expr $gI(4) - 1]
   set nR [expr $gI(5) - 1]

# FIRST non-empty column 

   set Done 0
   set Edge(0) $nR
   for { set C 0 } { $C <= $nC } { incr C } {
      for { set R 0 } { $R <= $nR } { incr R } {
         TUgridInfo 1 gI rV $C $R
         if { ($N($rV(0)) > 0.0) && ($G($rV(0)) > $oP(0)) } { 
	    set Edge(0) $C
	    set Done 1
	    break
	 }
      }
      if $Done { break }
   }

# LAST non-empty column 

   if { $Edge(0) < $nC } { 
      set Done 0
      set Edge(1) $nC
      for { set C $nC } { $C >= 0 } { incr C -1 } {
         for { set R 0 } { $R <= $nR } { incr R } {
            TUgridInfo 1 gI rV $C $R
            if { ($N($rV(0)) > 0.0) && ($G($rV(0)) > $oP(0)) } { 
	       set Edge(1) $C
	       set Done 1
	       break
	    }
         }
         if $Done { break }
      }
   } else { set Edge(1) $nC }

# FIRST non-empty row 

   set Done 0
   set Edge(2) $nR
   for { set R 0 } { $R <= $nR } { incr R } {
      for { set C 0 } { $C <= $nC } { incr C } {
         TUgridInfo 1 gI rV $C $R
         if { ($N($rV(0)) > 0.0) && ($G($rV(0)) > $oP(0)) } { 
	    set Edge(2) $R
	    set Done 1
	    break
	 }
      }
      if $Done { break }
   }

# LAST non-empty row 

   if { $Edge(2) < $nR } { 
      set Done 0
      set Edge(3) $nR
      for { set R $nR } { $R >= 0 } { incr R -1 } {
         for { set C 0 } { $C <= $nC } { incr C } {
            TUgridInfo 1 gI rV $C $R
            if { ($N($rV(0)) > 0.0) && ($G($rV(0)) > $oP(0)) } { 
	       set Edge(3) $R
	       set Done 1
	       break
	    }
         }
         if $Done { break }
      }
   } else { set Edge(3) $nR }

# SEE if the grid can be clipped.  DO NOT clip a grid which would take 
#    either of the two dimensions to 0.

   if { ($Edge(0) == $Edge(1)) || ($Edge(2) == $Edge(3)) } {
       set CmD EDGES
   }

# IF NEED TO CLIP THE GRID DO THAT HERE

   if ![string match EDGES $CmD] {
      switch -exact -- $CmD {
         REGRID {
            set lC $Edge(0)
            set uC $Edge(1)
            set lR $Edge(2)
            set uR $Edge(3)
         }
         REGRIDX {
            set lC $Edge(0)
            set uC $Edge(1)
            set lR 0
            set uR [expr $gI(5) - 1]
         }
         REGRIDY {
            set lR $Edge(2)
            set uR $Edge(3)
            set lC 0
            set uC [expr $gI(4) - 1]
         }
      }

      set nE 0
      if [string match ROW $gI(8)] {
         for { set I $lR } { $I <= $uR } { incr I } {
            for { set J $lC } { $J <= $uC } { incr J } {
                set K [expr $J + $I * $gI(5)]
                set G($nE) $G($K)
                set N($nE) $N($K)
                incr nE
            }
         }
      } else {
         for { set I $lC } { $I <= $uC } { incr I } {
            for { set J $lR } { $J <= $uR } { incr J } {
                set K [expr $J + $I * $gI(4)]
                set G($nE) $G($K)
                set N($nE) $N($K)
                incr nE
            }
         }
      }

# GET the new grid limits

      TUgridInfo 1 gI rG $lC 0 
      TUgridInfo 21 gI rV $rG(0) 
      set gI(0) $rV(14)
      TUgridInfo 1 gI rG $uC 0 
      TUgridInfo 21 gI rV $rG(0)
      set gI(1) $rV(6)
      TUgridInfo 1 gI rG 0 $lR
      TUgridInfo 21 gI rV $rG(0)
      set gI(2) $rV(15)
      TUgridInfo 1 gI rG 0 $uR
      TUgridInfo 21 gI rV $rG(0)
      set gI(3) $rV(7)

# LAST step in the trim is to reset the grid info array.  Be sure that if
#    we reduce a cyclic dimension that it be made no longer cyclic

      set T $gI(4)
      set gI(4) [expr $uC - $lC + 1]
      if { $T != $gI(4) } { set gI(15) NO }
      set T $gI(5)
      set gI(5) [expr $uR - $lR + 1]
      if { $T != $gI(5) } { set gI(16) NO }
   }

   if { $oP(1) == 1 } {
      set Edge(1) [expr $nC - $Edge(1)]
      set Edge(3) [expr $nR - $Edge(3)]
   } 

   return [list $Edge(0) $Edge(1) $Edge(2) $Edge(3)]
}
