#  THIS procedure returns or stores a row or column of data within a grid.

#  gInFo - Grid Information
#          0:  Beginning X grid position 
#          1:  Ending X grid position 
#          2:  Beginning Y grid position 
#          3:  Ending Y grid position 
#          4:  Number of grids along X
#          5:  Number of grids along Y
#          6:  User POINT or BAND method to store X data
#          7:  User POINT or BAND method to store Y data
#          8:  Storage Method ROW or COLUMN
#          9:  IGNORE or KEEP Zeros when averaging 
#         10:  NEW and ADD (initialize) or ADD ( just add to) grid or  
#              ADDEND  ADD (add to and normalize) grid or END   
#         11:  Value to initialize grid to
#         12:  Value used to indicate a bad grid point
#         13:  Remove data below this value
#         14:  Remove data above this value
#         15:  Cyclic in X
#         16:  Cyclic in Y

package provide TclUtils 1.0

proc TUgridRowCol { Grid gInfo  RowCol ActioN IteM Offset { IniT NO } \
                                               { BaD NO } { ExPanD NO } } {
 
   upvar $Grid G
   upvar $gInfo gI
   upvar $RowCol rC

# ESTABLISH the coefficients of the equation which will return the element
#    number in a grid given a row and column number
#
#               gN = A * rN + B * cN

      if [string match ROW $gI(8)] {
         set A $gI(4)
         set B 1
      } else {
         set A 1
         set B $gI(5)
      }

   if [string match RETRIEVE $ActioN] {
      if [string match ROW $IteM] {
         set rV $gI(4)
         set P [ expr int($A * $Offset)]
         for { set I 0 } { $I < $gI(4) } { incr I ; incr P $B } {
            set rC($I) $G($P)
         }
      } else {
         set rV $gI(5)
         set P [ expr int($B * $Offset) ]
         for { set I 0 } { $I < $gI(5) } { incr I ; incr P $A } {
            set rC($I) $G($P)
         }
      }

      if ![string match NO $IniT] {
         for { set I 0 } { $I < $rV } { incr I } {
            if { $rC($I) == $gI(11) } { set rC($I) $IniT } 
         }
      }

      if ![string match NO $BaD] {
         for { set I 0 } { $I < $rV } { incr I } {
            if { $rC($I) == $gI(12) } { set rC($I) $BaD } 
         }
      }

      if ![string match NO $ExPanD] {
         set nP 1
         while { $nP < $rV } { set nP [expr $nP << 1] }
         for { set I $rV } { $I < $nP } { incr I } { set rC($I) $ExPanD }
         set rV $nP
      }
   } else {
      if [string match ROW $IteM] {
         set rV $gI(4)
         set P [ expr $A * $Offset ]
         for { set I 0 } { $I < $gI(4) } { incr I ; incr P $B } {
            set G($P) $rC($I)
         }
      } else {
         set rV $gI(5)
         set P [ expr $B * $Offset ]
         for { set I 0 } { $I < $gI(5) } { incr I ; incr P $A } {
            set G($P) $rC($I)
         }
      }
   }

  return $rV
}
