#  THIS proceduce reorganizes a grid into a new grid.  It can:
#      CUT a piece out of a grid
#      REGRID a grid giving it a new grid size

#
#  Available variables for use in the functions:
#    $CnT       - the number of elements put into the collapsed grid
#    $G($oV(0)) - the element being added
#    $Sum       - the sum of the collapsed elements for the new grid

package provide TclUtils 1.0

proc TUgridReGrid { Action Grid gInfo rGrid rgInfo rNorM { EndCmd END } } {
   global PI RtoD

   upvar $Grid oG
   upvar $gInfo ogI
   upvar $rGrid nG
   upvar $rgInfo ngI
   upvar $rNorM NrM

   switch -exact -- $Action {
      CUT     {
         TUgridInfo 0 ogI BrV $ngI(0) $ngI(2)
         TUgridInfo 0 ogI ErV $ngI(1) $ngI(3)
         if [string match YES $ogI(15)] { set AddX $ogI(4) } else { set AddX 0 }
         if [string match YES $ogI(16)] { set AddY $ogI(5) } else { set AddY 0 }
         set ngI(4) [expr ($AddX + $ErV(1) - $BrV(1) + 1) % $ogI(4)]
         set ngI(5) [expr ($AddY + $ErV(2) - $BrV(2) + 1) % $ogI(5)]
         for { set I 6 } { $I < 17 } { incr I } { set ngI($I) $ogI($I) }
         
         if { ( $ngI(4) <= 0 ) || ( $ngI(5) < 0 ) } { return -1 }

         set K 0
         if [string match COLUMN $ogI(8)] {
            for { set I $BrV(1) } { $I <= $ErV(1) } { incr I } {
               TUgridInfo 1 ogI rV $I 0
               for { set J 0 } { $J < $ngI(5) } { incr K ; incr J } {
                  set nG($K) $oG([expr $rV(0) + ($BrV(2) + $J) % $ogI(5)])
               }
            }
         } else {
            for { set I $BrV(2) } { $I <= $ErV(2) } { incr I } {
               TUgridInfo 1 ogI rV $BrV(1) $I
               for { set J 0 } { $J < $ngI(4) } { incr K ; incr J } {
                   set nG($K) $oG([expr $rV(0) + ($BrV(1) + $J) % $ogI(4)])
               }
            }
         }
      }
      REGRID  {

# INITIALIZE the new grid

         set ngI(10) NEW
         TUdataGrid 0 1 Dummy Dummy 1 Dummy Dummy Dummy nG NrM ngI

# RETRIEVE the center X and Y coordinates for the old grid

         TUgridInfo 32 ogI Xx
         TUgridInfo 33 ogI Yy

         set ngI(10) ADD
         if [string match COLUMN $ogI(8)] {
            set K 0
            for { set I 0 } { $I < $ogI(4) } { incr I } {
               set X(0) $Xx($I)
               for { set J 0 } { $J < $ogI(5) } { incr J } {
                   set V($J) $oG($K) ; incr K
               }
               TUdataGrid $ogI(5) $ogI(5) X X 1 Yy Yy V nG NrM ngI
            }
         } else {
            set K 0
            for { set I 0 } { $I < $ogI(5) } { incr I } {
               set Y(0) $Yy($I)
               for { set J 0 } { $J < $ogI(4) } { incr J } {
                   set V($J) $oG($K) ; incr K
               }
               TUdataGrid $ogI(4) 1 Xx Xx $ogI(4) Y Y V nG NrM ngI
            }
         }
         if [string match END $EndCmd] {
            set ngI(10) END
            TUdataGrid 0 1 Dummy Dummy 1 Dummy Dummy Dummy nG NrM ngI
         }
      }
   } 
   return 1
}
