#  gInFo - Processing Information
#          0:  Beginning X grid position 
#          1:  Ending X grid position 
#          2:  Beginning Y grid position 
#          3:  Ending Y grid position 
#          4:  Number of grids along X
#          5:  Number of grids along Y (= 1 for 1D data)
#          6:  User POINT or BAND method to store X data
#          7:  User POINT or BAND method to store Y data
#          8:  Storage Method ROW or COLUMN
#          9:  IGNORE or KEEP Zeros when averaging 
#         10:  NEW (initialize) and/or ADD ( just add to) grid or  
#              END (normalize) grid.  Order is important since it does 
#              actions in order stated. Order should be NEW:ADD:END
#         11:  Value to set unfilled grids to
#         12:  Set bad data to this value
#         13:  Remove Data below this value
#         14:  Remove Data above this value
#

package provide TclUtils 1.0

proc TUgridPrint { File Grid Err gInFo AcTioN {DoClose 1} } {
 
   upvar $Grid  G
   upvar $Err   E
   upvar $gInFo gI

   if [info exists E] {
       set FmT "%.6e  %.6e  %.6e  %.6e"
       set PrLine { set OuT [format $FmT $rI(2) $rI(3) $G($I) $E($I)]}
   } else {
       set FmT "%.6e  %.6e  %.6e  0.000"
       set PrLine { set OuT [format $FmT $rI(2) $rI(3) $G($I)]}
   }

   switch -exact -- $AcTioN {
      OpenW  {        
         if [catch { open $File w } fd ] {
            puts stderr "TUgridPrint ERROR ... CANNOT OPEN\n $File"
            return
         }
      }
      OpenA  {        
         if [catch { open $File a } fd ] {
            puts stderr "TUgridPrint ERROR ... CANNOT OPEN\n $File"
            return
         }
      }
      Opened {        
         set fd $File
      }
   }

# TOTAL number of grids.

   set TotGrids [ expr $gI(4) * $gI(5) ]

# OUTPUT the Grid Information Array

   puts $fd "XSTART   : $gI(0)"
   puts $fd "XEND     : $gI(1)"
   puts $fd "YSTART   : $gI(2)"
   puts $fd "YEND     : $gI(3)"
   puts $fd "XLENGTH  : $gI(4)"
   puts $fd "YLENGTH  : $gI(5)"
   puts $fd "XSTORAGE : $gI(6)"
   puts $fd "YSTORAGE : $gI(7)"
   puts $fd "GSTORAGE : $gI(8)"
   puts $fd "ZEROS    : $gI(9)"
   puts $fd "DO       : $gI(10)"
   puts $fd "UNFILLED : $gI(11)"
   puts $fd "BAD      : $gI(12)"
   puts $fd "GMIN     : $gI(13)"
   puts $fd "GMAX     : $gI(14)"
   puts $fd "XCYCLIC  : $gI(15)"
   puts $fd "YCYCLIC  : $gI(16)"
   puts $fd "XSCALE   : $gI(17)"
   puts $fd "YSCALE   : $gI(18)"

   for { set I 0  } { $I < $TotGrids  } { incr I } { 
       TUgridInfo 20 gI rI $I
       eval $PrLine
       puts $fd $OuT
   }

   if {$DoClose == 1} { close $fd ; set fd -1 }
   return $fd
}
