#  gInFo - Grid Information
#          0:  Beginning X grid position 
#          1:  Ending X grid position 
#          2:  Beginning Y grid position 
#          3:  Ending Y grid position 
#          4:  Number of grids along X
#          5:  Number of grids along Y
#          6:  User POINT or BAND method to store X data
#          7:  User POINT or BAND method to store Y data
#          8:  Storage Method ROW or COLUMN
#          9:  IGNORE or KEEP Zeros when averaging 
#         10:  NEW and ADD (initialize) or ADD ( just add to) grid or  
#              ADDEND  ADD (add to and normalize) grid or END   
#         11:  Value to initialize grid to
#         12:  Value used to indicate a bad grid point
#         13:  Remove data below this value
#         14:  Remove data above this value
#         15:  Cyclic in X
#         16:  Cyclic in Y
#
#  sInFo - Grid Filling Information
#          0: Maximum number neighbors to use per quadrant
#          1: Maximum search radius from grid being fit
#          2: Minimum number of quads filled for iteration to be attempted
#          3: 1 = fit can't produce a maximum above nearest valid value
#             2 =  fit can't produce a maximum above any included valid value
#          4: Xmin edge location
#          5: Xmax edge location
#          6: Ymin edge location
#          7: Ymax edge location
#          8: Weighting factor (W = exp(sInfo(8) * log(MinD/D)
#          9: Order

package provide TclUtils_C 1.0

proc TUgridFill2D { Grid gInFo Norm sInFo } {
 
   upvar $Grid G
   upvar $gInFo gI
   upvar $sInFo sI

# SET of random number in case we need to jitter X or Y

   TUdataRnd1 rN 100 PN .02

# OBTAIN the absolute end mesh positions and the mesh dimensions

   set LastX [expr $gI(4) - 1]
   set LastY [expr $gI(5) - 1]
   set gX [expr int($gI(4))]
   set gY [expr int($gI(5))]

# IF the order is not specified set to 1

   if ![info exists sI(9)]  { set sI(9) 1 }

# Determine the minimum number of points needed for a fit.  This is
#   just the number of coefficients in the least squares.

   set MnV 1;
   for { set I 1 } { $I <= $sI(9) } { incr I } { 
      set MnV [expr $MnV + $I + 1]
   } 

# SET the cyclic flags and the grids which are to be considered the edges.
#    Grids at or below the edges need only 2 quadrants filled for iteration

   if [string match NO $gI(15)] { set XCyclic 0 } else { set XCyclic 1 } 
   if [string match NO $gI(16)] { set YCyclic 0 } else { set YCyclic 1 } 
   set xMinE $sI(4)
   set xMaxE [expr $LastX - $sI(5)]
   set yMinE $sI(6)
   set yMaxE [expr $LastY - $sI(7)]

   set rMax  [expr $sI(1) * $sI(1)]

# SET the number of neighbors to use.  For the most part this is just
#    what the user requests, however, a fit needs a minimum of MnV 
#    points.  We need to make sure that there are that many points
#    and to do this may need to adjust the number of values per quadrant
#    especially if there are less than the fill complement of quadrants
#    being used in the fit.

# IF only one quadrant of data is being used

   if { $sI(0) > $MnV } { set aN(0) $sI(0) } else { set aN(0) $MnV }

# IF only two quadrants of data are being used
   
   set TmP [expr ($MnV / 2) + $MnV % 2]
   if { $sI(0) > $TmP } { set aN(1) $sI(0) } else { set aN(1) $TmP }
  
# IF only three quadrants of data is being used

   set TmP [expr $MnV / 3]
   if { [expr $MnV % 3] > 0 } { incr TmP }
   if { $sI(0) > $TmP } { set aN(2) $sI(0) } else { set aN(2) $TmP }
  
# IF all four quadrants of data is being used

   set TmP [expr $MnV / 4]
   if { [expr $MnV % 4] > 0 } { incr TmP }
   if { $sI(0) > $TmP } { set aN(3) $sI(0) } else { set aN(3) $TmP }

# SET the maximum number of points which might be accumulated

   set TotD [expr 4 * $aN(0)]

#  SET factors which will take an X,Y grid location to a linear location in
#      the grid array.  These depend on how the grid was laid down which
#      could have been ROW by ROW or COLUMN by COLUMN.

   if [string match ROW $gI(8)] { 
     set Ax 1
     set Ay $gX
   } else { set Ax $gY ; set Ay 1 }

# CHECK to see if we have the Grid Normalization array.  If we do use that and
#   if not then try to recreate it.

   upvar $Norm nM
   set TotGrids [ expr $gI(4) * $gI(5) ]
   if ![info exists nM ] { 
       for { set I 0 } { $I < $TotGrids } { incr I } {
         if { $G($I) == $gI(11) } {
            set N($I) 0
         } elseif { $G($I) == $gI(12) } {
             set N($I) 2
         } else { set N($I) 1 }
      }
   } else {
      for { set I 0 } { $I < $TotGrids } { incr I } {
         if { $G($I) == $gI(12) } {
            set N($I) 2
         } elseif { $nM($I) == 0.0 } {
             set N($I) -1
         } else { set N($I) 1 }
      }
   }

# LOOP through all of the grids - inner loop is over rows and outer loop
#    is over columns

   for { set X 0 } { $X < $gI(4) } { incr X } {
      set sX [expr $Ax * $X]
      if { (($X <= $xMinE) || ($X >= $xMaxE)) && ($XCyclic == 0) } { 
         set xQ 1 
      } else { set xQ 0 }  

      set xS [expr int($X - $sI(1))]
      set xE [expr int($X + $sI(1))]
      set xC $X
      if { $XCyclic } {
         if { $xS < 0 } {
            set xS [expr int($xS + $gX)]
            set xE [expr int($xE + $gX)]
            set xC [expr int($xC + $gX)]
         }
      } else {
         if { $xS < $xMinE } { set xS $xMinE }
         if { $xE > $xMaxE } { set xE $xMaxE }
      }

      for { set Y 0 } { $Y < $gI(5) } { incr Y } {
         set gC [expr $sX + $Y * $Ay]
         if { $N($gC) > 0 } { continue } 

         if {$xQ || ((($Y <= $yMinE) || ($Y >= $yMaxE)) && ($YCyclic == 0))} { 
           if { $sI(2) > 2 } { set mQ 2 } else { set mQ $sI(2) }
         } else { set mQ $sI(2) }  
         set nT [expr $mQ -1]

         for { set I 0 } { $I < $TotD } { incr I } { set DataR($I) $TotGrids } 
         for { set I 0 } { $I < 4 } { incr I } { 
            set lMx($I) [expr $I * $aN($nT)]
            set Quad($I) 0
         }

         set yS [expr int($Y - $sI(1))]
         set yE [expr int($Y + $sI(1))]
         set yC $Y
         if { $YCyclic } {
            if { $yS < 0 } {
               set yS [expr int($yS + $gY)]
               set yE [expr int($yE + $gY)]
               set yC [expr int($yC + $gY)]
            }
         } else {
            if { $yS < $yMinE } { set yS $yMinE }
            if { $yE > $yMaxE } { set yE $yMaxE }
         }

         for { set x $xS } { $x <= $xE } { incr x } {
            set CoL [expr ($x % $gX) * $Ax]
            for { set y $yS } { $y <= $yE } { incr y } {
               set RoW [expr ($y % $gY) * $Ay]
               set gN [expr $CoL + $RoW]
               if { ($N($gN) != 1) } { continue }

               set xD  [expr $xC - $x]
               set yD  [expr $yC - $y]
               set R   [expr $xD * $xD + $yD * $yD]
               if { $R > $rMax } { continue }

               if { $xD == 0 } {
                  if { $yD > 0 } { set qX 0 } else { set qX 1 }
               } else { if { $xD > 0 } { set qX 0 } else { set qX 1 } }

               if { $yD == 0 } {
                   if { ($xD > 0) } { set qY 2 } else { set qY 0 }
               } else { if { ($yD >= 0) } { set qY 0 } else { set qY 2 } }

               set Q [expr $qX + $qY]

               set M $lMx($Q)
               if { $R < $DataR($M) } {
                  set DataX($M) $xD
                  set DataY($M) $yD
                  set DataV($M) $G($gN)
                  set DataR($M) [expr double($R)]
                  set oS [expr $Q * $aN($nT)] 
                  set lMx($Q) [TUdataMxMn DataR $aN($nT) > $gI(13) $gI(14) 1 $oS ]
                  set Quad($Q) 1
               }
            }
         }
         set nQ [expr $Quad(0) + $Quad(1) + $Quad(2) + $Quad(3)]   

         if { $nQ < $mQ } { 
            set N($gC) 0
            set G($gC) $gI(11)
         } else { 
            set MinR $DataR([TUdataMxMn DataR $TotD <]) 
            set CnT 0 
            for { set J 0 } { $J < $TotD } { incr J } {
               if { $DataR($J) != $TotGrids } {
                  set Mx($CnT) $DataX($J)
                  set My($CnT) $DataY($J)
                  set Mv($CnT) $DataV($J)
                  set Mw($CnT) [expr exp($sI(8) * log($MinR / $DataR($J)))]
                  incr CnT
               }
            }
        
            if { $CnT >= $MnV } {

# SCRAMBLE check.  Sometimes when the number of quadrants is < 3 you can
#   get a X or Y lying in a horizontal or vertical line.  Can produce
#   unstable fits!  So check and put some jitter into horizontal or
#   vertical data.
	       if  { $mQ < 3 } {
	          set rInc 0
	          set Xbase $Mx(0)
                  for { set J 1 } { $J < $CnT } { incr J } {
		     if { $Mx($J) != $Xbase } { break }
                  }
		  if { $J == $CnT } {
                     for { set J 0 } { $J < $CnT } { incr J ; incr rInc } {
		        set Mx($J) [expr $Mx($J) * (1.0 + $rN($rInc))]
		     }
                  }
	          set Ybase $My(0)
                  for { set J 1 } { $J < $CnT } { incr J } {
		     if { $My($J) != $Ybase } { break }
                  }
		  if { $J == $CnT } {
                     for { set J 0 } { $J < $CnT } { incr J ; incr rInc } {
		        set My($J) [expr $My($J) * (1.0 + $rN($rInc))]
		     }
                  }
	       }

	       set oP(OR) $sI(9)
	       TUdataLSq2D Mx My Mv $CnT 1 A iA oP CoVar "TUpoly2DFunc" Mw
               set N($gC) 0
               set G($gC) $A(0)
               if { $sI(3) == 1} {
                  set MaxV $Mv([TUdataMxMn Mw $CnT >]) 
                  if { $G($gC) > $MaxV } { set G($gC) $MaxV }
               } elseif {$sI(3) == 2 } {
                  set MaxV $Mv([TUdataMxMn Mv $CnT >]) 
                  if { $G($gC) > $MaxV } { set G($gC) $MaxV }
               }
            } else {
               set N($gC) 0
               set G($gC) $gI(11)
            }
         }
      }
   }
}
