# THIS procedure collapses a NxM grid into an Nx1 or Mx1 grid or an Nx1
#   grid into a 1x1 grid

package provide TclUtils 1.0

proc TUgridCollapse { iGrid igI mnV mxV cDir cFmt oGrid ogI  } {

   upvar $iGrid iG
   upvar $igI   gI
   upvar $oGrid oG
   upvar $ogI   gO

# SET up the collapse ranges which will depend on the direction we are
#    collapsing.  There are two sets of indices, one giving the collapse
#    range and one giving the scan range.  


   set tmn [string match MIN $mnV]
   set tmx [string match MAX $mxV]
   set tcd [string match X $cDir]

   if $tcd {
      set Low $gI(0) ; set Hi $gI(1) ; set nC $gI(4) ; set nS $gI(5)
      set Start $gI(2) ; set Stop $gI(3)
   } else { 
      set Low $gI(2) ; set Hi $gI(3) ; set nC $gI(5) ; set nS $gI(4)
      set Start $gI(0) ; set Stop $gI(1)
   }

   if $tmn { set mnV $Low }
   if $tmx { set mxV $Hi  }


# MAKE sure that grid range and min and max collapse values are both either
#   increasing or decreasing.

   if { (($Low > $Hi) && ($mxV > $mnV)) || (($Low < $Hi) && ($mxV < $mnV)) } {
      set TmP $mnV
      set mnV $mxV
      set mxV $TmP
   }

   if $tcd {
      if !$tmn {
         TUgridInfo 0 gI rC $mnV $Start
	 if { $rC(1) >= $nC } { 
	    return -1
         } elseif { $rC(1) < 0 } { set cBeg 0 } else {  set cBeg $rC(1) }
      } else { set cBeg 0 } 

      if !$tmx {
         TUgridInfo 0 gI rC $mxV $Start
	 if { $rC(1) >= $nC } { 
             set cEnd [expr $nC - 1] 
         } else { set cEnd $rC(1) }
      } else { set cEnd [expr $gI(4) - 1] }

      upvar 0 X I
      upvar 0 Y J
   } else {

# MAKE sure that grid range and min and max collapse values are both either
#   increasing or decreasing.

      if !$tmn {
         TUgridInfo 0 gI rC $Start $mnV
	 if { $rC(2) >= $nC } { 
	    return -1
         } elseif { $rC(1) < 0 } { set cBeg 0 } else {  set cBeg $rC(2) }
      } else { set cBeg 0 } 

      if !$tmx { 
         TUgridInfo 0 gI rC $Start $mxV 
	 if { $rC(2) >= $nC } { 
             set cEnd [expr $nC - 1] 
         } else { set cEnd $rC(2) }
      } else { set cEnd [expr $nC - 1] }

      upvar 0 X J
      upvar 0 Y I
   }

# SET up the grid information array of the returned grid

   set gO(0) $Start
   set gO(1) $Stop
   set gO(2) -1
   set gO(3) 1
   set gO(4) $nS
   set gO(5) 1
   for { set I 6 } { $I <  19 } { incr I } { set gO($I) $gI($I)) }

# SET up some parameters which allows us to bypass the call to TUgridInfo
#   and compute gird cell locations from row and column directly

   set aF [string match AVG $cFmt]
   set sF [string match COLUMN $gI(8)]
   set cX [string match YES $gI(15)]
   set cY [string match YES $gI(16)]

# DO the collapse.  The inner loop is always the collapse loop while the
#   outer loop is the scan loop.  The scan loop always starts at 0.

   for { set J 0 } { $J < $nS } { incr J } {
      set CnT 0
      set Sum 0.0
      for { set I $cBeg } { $I <=  $cEnd } { incr I } {
         if $cX { set X  [expr ($X + $gI(4)) % $gI(4)] }
         if $cY { set Y  [expr ($Y + $gI(5)) % $gI(5)] }
	 if $sF {
	    set gP [expr int($X * $gI(5) + $Y)]
         } else { set gP [expr int($Y * $gI(4) + $X)] }
	 if { $iG($gP) != $gI(12) } {
	    set Sum [expr $Sum +  $iG($gP)]
	    incr CnT
	 }
      }

      if { $CnT > 0 } {
         if $aF {
            set oG($J) [expr $Sum / double($CnT)]
         } else { set oG($J) $Sum }
      } else { set oG($J) $gI(12) }
   }

# AT this point we should have a grid of data which is either gI(4) x 1 or
#   gI(5) x 1 depending on which direction we were collapsing.

   return (1)
}
