package provide TclUtils 1.0

#  Gamma Function Generator
#
#  V   - value
#  ReT - return gamma (GAMMA) or log gamma (LGAMMA)

proc TUgammaFn { V ReT } {

   if { $V <= 0.0 } { return BaD }

   set C(0)  76.18009172947146
   set C(1) -86.50532032941677
   set C(2)  24.01409824083091
   set C(3)  -1.231739572450155
   set C(4)   0.1208650973866179e-2
   set C(5)  -0.5395239384953e-5
                                                                                
   set Y $V     
   set X $V     
   set T [expr $X + 5.5]
   set T [expr $T - ($X + 0.5) * log($T)]
   set S 1.000000000190015
   
   for { set I 0 } { $I <= 5 } { incr I } {
       set Y [expr $Y + 1.0]
       set S [expr $S + $C($I) / $Y]  
   }

   set lG [expr -$T  +log(2.5066282746310005 * $S / $X)]
   if { [string compare LGAMMA $ReT] == 0 } {
      set rV $lG 
   } else { set rV [expr exp($lG)] }

   return $rV
}
