#  THIS is a general Tcl file seek routine.
#
#  INPUTS:
#     fd     - file descripter
#     Offset - byte offset 
#     Origin - origin of the byte offset
#                start   - beginning of file
#                current - from the current location
#                end     - from the end of the file.
#
#  RETURN: -l if off the end and offset if OK.

package provide TclUtils 1.0

proc TUfileSeek { fd Offset Origin } {

# THIS is the current byte location in the file

   set Cur [tell $fd]

# THIS is the byte location at the file end

   seek $fd 0 end
   set EnD [tell $fd]

# BACK to where we came in at

   seek $fd $Cur start
                                                                                
# SEE where this seek will put us in the file

   switch -exact -- $Origin {
      start   { set Next $Offset }
      current { set Next [expr $Cur + $Offset] }
      end     { set Next [expr $EnD + $Offset] }
   }

# IF the seek moves us off the end of the file or before the start then do
#   nothing and return a -1.  If we are within the file do the seek and
#   return the current byte location.
                                                                                
   if {($Next > $EnD) || ($Next < 0) } {
      set Ret -1
   } else {
      seek $fd $Offset $Origin
      set Ret [tell $fd]
   }
                                                                                
   return $Ret
}
