#
#  SNstat - evaluates the average and varience in a data array
#
#  INPUTS:   X - the data array
#            N - Length of the data array
#            Skip - Increment size for data array
#            Off  - Offset into data array
#
#  OUTPUTS:  Returned List
#            Index 0 - Average of X
#            Index 1 - Varience in X

package provide TclUtils 1.0

proc TUdataStat { Data N {Skip 1} {Off 0} } { 
   
   upvar $Data X

   if { $N == 0 } {
      set ReT [list 0.0 0.0 ]
      return $ReT
   }

   set Sum  0.0
   set J $Off
   for { set I 0 } { $I < $N } { incr I ; incr J $Skip} { 
      set Sum [expr $Sum + $X($J)] 
   }
   set XAvg [expr $Sum / double($N)]

   set Sum  0.0
   set J $Off
   for { set I 0 } { $I < $N } { incr I ; incr J $Skip } { 
     set V [expr $X($J) - $XAvg ]
     set Sum [expr $Sum + $V * $V]
   }
   set XVar [expr $Sum / double($N - 1.0)]

   set ReT [list $XAvg $XVar ]
   return $ReT
}
