package provide TclUtils 1.0

#  Random Number Generator + and negative
#
#  Data - out (array)
#  Np   - number of values to generate
#  RnG  - value range
#       - NP or PN positive and negative values
#       - P positive values
#       - N negative values
#  Max  - Maximum generated random number

proc TUdataRndNorm { Data Np {Max 1.0} } {
   global TwoPI

   upvar $Data V

   TUdataRnd1 rV $Np P 1.0

   set J 0
   for { set I 0 } { $I < $Np } { incr I } {
      TUdataRnd1 rV 2 P 1.0
      set lnT [expr sqrt (-2.0 * log($rV(0)))]
      set anG [expr $TwoPI * $rV(1)]
      set V($J) [expr $lnT * cos($anG)] ; incr J
      set V($J) [expr $lnT * sin($anG)] ; incr J
   }

   return $V(0)
}
