#  Correlation and Autocorrelation
#
#  usage
#      TUcorrFunc D1 N1 D2 N2 Cor
#
#  INPUTS
#     D1        Data set 1
#     N1        Length of D1  
#     D2        Data set 2
#     N2        Length of D2  
#     Cor       Correlation or Auto-correlation
#     Lag       Lag
#
#  Internally the larger data set will be zero padded to have a length which 
#    is an integral power of 2.  Then the smaller data set will be  padded 
#    to the lenght of the larger.
#

package provide TclUtils 1.0

proc TUcorrFunc { D1 N1 D2 N2 Cor Lag } {

   upvar $D1  X
   upvar $D2  Y
   upvar $Cor C
   upvar $Lag cL

# FIND out which data set is the larger of the two

   if { $N1 < $N2 } { set MaxN $N2 } else { set MaxN $N1 }

# GET the closest power of two to the larger data set

   set N 1
   while { $N < $MaxN } { set N [expr $N * 2] }

# PAD both data sets to the power of 2.  There will be no padding if the
#   data set(s) are of the correct length(s)

   for { set I $N1 } { $I < $N } { incr I } { set X($I) 0.0 }
   for { set I $N2 } { $I < $N } { incr I } { set Y($I) 0.0 }

# COMPUTE the FFT's of X and Y

   TwoFfT X Y fftX fftY $N

# MULTIPLY the ffts 

   set hP [expr double($N >> 1)]
   set EnD [expr $N + 2]
   for { set I 0 ; set J 1 } { $I < $EnD } { incr I 2 ; incr J 2 } {
      set T $fftY($I)
      set fftY($I) [expr ($fftX($I) * $T + $fftX($J) * $fftY($J)) / $hP]
      set fftY($J) [expr ($fftX($J) * $T - $fftX($I) * $fftY($J)) / $hP]
   }

# TAKE the inverse

   set fftY(1) $fftY($N)
   RealFfT fftY $N -1

# GET the lags ordered to run from -N/2 to +N/2

   set J 0
   set E [expr $N / 2]

   for { set I $E } { $I < $N } { incr I ; incr J } { 
       set C($J) $fftY($I)
       set cL($J) [expr $J - $E]
   }

   for { set I 0 } { $I < $E } { incr I ; incr J } { 
       set C($J) $fftY($I)
       set cL($J) $I
   }
   return 1
}
