package provide TclUtils 1.0

proc TUcomplexMath { rA iA Action rB iB rC iC Len { Xa 0} { Xb 0} { Xc 0 } \
                                      { dA 1 } { dB 1 } { dC 1 } } {
   global PI RtoD

   upvar $rA ra
   upvar $iA ia

  if [regexp {^[+-]?(([0-9]*\.[0-9]+)|([0-9]+\.[0-9]*)|([0-9]+))((e|E)[+-]?[0-9]+)?$} $rB] {
     set rb(0) $rB
     set ib(0) $iB
     set dB 0
  } else { upvar $rB rb ; upvar $iB ib }

   upvar $rC rc
   upvar $iC ic

   set T 0.0
   switch -exact -- $Action {
      CC {   
	 TUarrayMath ra * ra rT $Len $Xa $Xb $Xc $dA $dB $dC
	 TUarrayMath ia * ia iT $Len $Xa $Xb $Xc $dA $dB $dC
	 TUarrayMath rT + iT rc $Len $Xa $Xb $Xc $dA $dB $dC
	 TUarrayMath rT * 0.0 ic $Len $Xa $Xb $Xc $dA $dB $dC
      } 
      + -   
      - {   
	 TUarrayMath ra $Action rb rc $Len $Xa $Xb $Xc $dA $dB $dC
	 TUarrayMath ia $Action ib ic $Len $Xa $Xb $Xc $dA $dB $dC
      }
      * {   
         TUarrayMath ra * rb rT $Len $Xa $Xb $Xc $dA $dB $dC
         TUarrayMath ia * ib iT $Len $Xa $Xb $Xc $dA $dB $dC
         TUarrayMath rT - iT rc $Len $Xa $Xb $Xc $dA $dB $dC
         TUarrayMath ra * ib rT $Len $Xa $Xb $Xc $dA $dB $dC
         TUarrayMath ia * rb iT $Len $Xa $Xb $Xc $dA $dB $dC
         TUarrayMath rT * iT ic $Len $Xa $Xb $Xc $dA $dB $dC
      }
      / {   
         TUarrayMath ra * rb rT $Len $Xa $Xb $Xc $dA $dB $dC
         TUarrayMath ia * ib iT $Len $Xa $Xb $Xc $dA $dB $dC
         TUarrayMath rT - iT rN $Len $Xa $Xb $Xc $dA $dB $dC
         TUarrayMath ra * ib rT $Len $Xa $Xb $Xc $dA $dB $dC
         TUarrayMath ia * rb iT $Len $Xa $Xb $Xc $dA $dB $dC
         TUarrayMath rT * iT iN $Len $Xa $Xb $Xc $dA $dB $dC
	 TUarrayMath rb * rb rT $Len $Xa $Xb $Xc $dA $dB $dC
	 TUarrayMath ib * ib iT $Len $Xa $Xb $Xc $dA $dB $dC
	 TUarrayMath rT + iT Denom $Len $Xa $Xb $Xc $dA $dB $dC
	 TUarrayMath rN / Denom rc $Len $Xa $Xb $Xc $dA $dB $dC
	 TUarrayMath iN / Denom ic $Len $Xa $Xb $Xc $dA $dB $dC
      }
   }

   return $T
}
