package provide TclUtils_C 1.0

proc TUarrayMath { A Action B C Len { Xa 0} { Xb 0} { Xc 0 } \
                                      { dA 1 } { dB 1 } { dC 1 } } {
   global PI RtoD

   upvar $A V
   if [regexp {^[+-]?(([0-9]*\.[0-9]+)|([0-9]+\.[0-9]*)|([0-9]+))((e|E)[+-]?[0-9]+)?$} $B] {
      set W $B
   } else { upvar $B W }
   upvar $C R
    
   set T 0.0
   set EnD [expr $Len + $Xa]
   switch -exact -- $Action {
      ACOS   {  
         for { } { $Xa < $EnD } { incr Xa $dA ; incr Xc $dC } {
            set R($Xc) [expr acos($V($Xa))]
         }
      }

      ACOSD   {  
         for { } { $Xa < $EnD } { incr Xa $dA ; incr Xc $dC } {
            set R($Xc) [expr $RtoD * acos($V($Xa))]
         }
      }

      ALOG   {  
         for { } { $Xa < $EnD } { incr Xa $dA ; incr Xc $dC } {
            set R($Xc) [expr exp($V($Xa))]
         }
      }

      ALOG10   {  
         for { } { $Xa < $EnD } { incr Xa $dA ; incr Xc $dC } {
            set R($Xc) [expr pow(10.0, ($V($Xa)))]
         }
      }

      ATAN   {  
         for { } { $Xa < $EnD } { incr Xa $dA ; incr Xb $dB ; incr Xc $dC } {
            set R($Xc) [expr atan2($W($Xb), $V($Xa))]
         }
      }

      ATAND  {  
         for { } { $Xa < $EnD } { incr Xa $dA ; incr Xb $dB ; incr Xc $dC } {
            set R($Xc) [expr $RtoD * atan2($W($Xb), $V($Xa))]
         }
      }

      AVG   {  
         for { set Cnt 0 } { $Xa < $EnD } { incr Cnt; incr Xa $dA } {
            set T [expr $T + $V($Xa)]
         }
         set T [expr $T / double ($Cnt)]
      }

      COS   {  
         for { } { $Xa < $EnD } { incr Xa $dA ; incr Xc $dC } {
            set R($Xc) [expr cos($V($Xa))]
         }
      }

      COSD   {  
         for { } { $Xa < $EnD } { incr Xa $dA ; incr Xc $dC } {
            set R($Xc) [expr cos($V($Xa) / $RtoD)]
         }
      }

      LOG10   {  
         for { } { $Xa < $EnD } { incr Xa $dA ; incr Xc $dC } {
            if { $V($Xa) > 0.0 } {
               set R($Xc) [expr log10($V($Xa))]
            } else { set R($Xc) $W } 
         }
      }

      LOGE   {  
         for { } { $Xa < $EnD } { incr Xa $dA ; incr Xc $dC } {
            if ( $V($Xa) > 0.0 ) {
               set R($Xc) [expr log($V($Xa))]
            } else { set R($Xc) $W } 
         }
      }

      SIN   {  
         for { } { $Xa < $EnD } { incr Xa $dA ; incr Xc $dC } {
            set R($Xc) [expr sin($V($Xa))]
         }
      }

      SIND   {  
         for { } { $Xa < $EnD } { incr Xa $dA ; incr Xc $dC } {
            set R($Xc) [expr sin($V($Xa) / $RtoD)]
         }
      }

      SQRT   {  
         for { } { $Xa < $EnD } { incr Xa $dA ; incr Xc $dC } {
            set R($Xc) [expr sqrt($V($Xa))]
         }
      }

      SUM   {  
         for { } { $Xa < $EnD } { incr Xa $dA } { set T [expr $T + $V($Xa)] }
      }

      VAR   {  
         for { set Cnt 0 } { $Xa < $EnD } { incr Cnt; incr Xa $dA } {
            set Q [expr $V($Xa) - $W]
            set T [expr $T + $Q * $Q]
         }
         set T [expr $T / double ($Cnt - 1)]
      }

      default {   
         if [array exists W] {
            for { } { $Xa < $EnD } {incr Xa $dA ; incr Xb $dB ; incr Xc $dC} {
               set R($Xc) [expr $V($Xa) $Action $W($Xb)]
            }
         } else {
            for { } { $Xa < $EnD } { incr Xa $dA ; incr Xc $dC } {
               set R($Xc) [expr $V($Xa) $Action $W]
            }
         }
      }
   }

   return $T
}
