#include <tcl.h>

int ArrayMathCmd (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 
int DataGridCmd (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 
int DataMqCoefCmd (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 
int DataMxMnCmd (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 
int DataLSq1DCmd (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 
int DataLSq2DCmd (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 
int DataLSq3DCmd (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 
int DataNLinLSqCmd (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 
int DataRnd1Cmd (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 
int GridFillCmd (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 
int IntegTrapCmd (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 
int PolyExp1DCmd (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 
int MatrixInvCmd (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 
int MatrixMathCmd (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 
int PolyExp2DCmd (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 
int SolveCubicCmd (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 
int VecMathCmd (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 


int Tclutil_Init (Tcl_Interp *interp) {
   Tcl_CreateObjCommand (interp, "TUarrayMath", ArrayMathCmd, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);

   Tcl_CreateObjCommand (interp, "TUgridFill2D", GridFillCmd, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);

   Tcl_CreateObjCommand (interp, "TUintegTrap", IntegTrapCmd, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);

   Tcl_CreateObjCommand (interp, "TUdataMqCoef", DataMqCoefCmd, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);

   Tcl_CreateObjCommand (interp, "TUdataMxMn", DataMxMnCmd, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);

   Tcl_CreateObjCommand (interp, "TUdataRnd1", DataRnd1Cmd, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);

   Tcl_CreateObjCommand (interp, "TUpolyExp1D", PolyExp1DCmd, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);

   Tcl_CreateObjCommand (interp, "TUpolyExp2D", PolyExp2DCmd, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);

   Tcl_CreateObjCommand (interp, "TUmatrixInv", MatrixInvCmd, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);

   Tcl_CreateObjCommand (interp, "TUmatrixMath", MatrixMathCmd, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);

   Tcl_CreateObjCommand (interp, "TUdataLSq1D", DataLSq1DCmd, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);

   Tcl_CreateObjCommand (interp, "TUdataLSq2D", DataLSq2DCmd, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);

   Tcl_CreateObjCommand (interp, "TUdataLSq3D", DataLSq3DCmd, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);

   Tcl_CreateObjCommand (interp, "TUdataNLinLSq", DataNLinLSqCmd, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);

   Tcl_CreateObjCommand (interp, "TUdataGrid", DataGridCmd, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);

   Tcl_CreateObjCommand (interp, "TUvecMath", VecMathCmd, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);

   Tcl_CreateObjCommand (interp, "TUsolveCubic", SolveCubicCmd, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);

   Tcl_PkgProvide(interp, "TclUtils_C",  "2.0");

   return TCL_OK;
}
