/*  The C equivalent of TUmatrixMath,  It consists of a TCL interface over  */
/*  a straight C subroutine                                                 */
/*                                                                          */
/*  There are 12 OBJV elements.  These are:                                 */
/*     OBJV[0]:  Routine name                                               */
/*     OBJV[1]:  Input Matrix Array A                                       */
/*     OBJV[2]:  Action                                                     */
/*     OBJV[3]:  Input Matrix Array B                                       */
/*     OBJV[4]:  Out Matrix Array C                                         */
/*     OBJV[5]:  Rows in Matrix A                                           */
/*     OBJV[6]:  Columns in Matrix A                                        */
/*     OBJV[7]:  Rows in Matrix B                                           */
/*     OBJV[8]:  Columns in Matrix B                                        */
/*     OBJV[9]:  Offset Into in Matrix A array                              */
/*     OBJV[10]: Offset Into in Matrix B array                              */
/*     OBJV[11]: Offset Into in Matrix C array                              */

#include <tcl.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "ByteDefs.h"
#include "TutilAnsi.h"

int MatrixMathCmd (ClientData cD, Tcl_Interp *tI, 
                                int objc, Tcl_Obj *CONST *objv) 
{
   ByTe_1 *Oper, oP; 
   ReaL_8 *mA, *mB, *mC; 
   ReaL_8 rV = 0.0; 
   ByTe_4 rN; 
   int mO[3] = {0, 0, 0};
   int mAi[2], mBi[2], rC, cC;
   int sA, sB, sC;
   ByTe_4 Bytes;

   void *memPtr;
   Tcl_Obj *objPtr;
   
/* Make sure that the minimum number of IO parameters are present          */

   if (objc < 9 ) {
     Tcl_WrongNumArgs(tI, 1, objv, "Usage: TUmatrixMath A Action B C .. ");
     return TCL_ERROR;
   }

/* Get the optional parameters input parameters                            */

   if (objc >= 10)  { Tcl_GetIntFromObj (tI, objv[9],  &mO[0]); }
   if (objc >= 11)  { Tcl_GetIntFromObj (tI, objv[10], &mO[1]); }
   if (objc >= 12)  { Tcl_GetIntFromObj (tI, objv[11], &mO[2]); }
 
/* Get the constant parameters input parameters                            */

   Oper = Tcl_GetString(objv[2]);
   Tcl_GetIntFromObj (tI, objv[5], &mAi[0]);
   Tcl_GetIntFromObj (tI, objv[6], &mAi[1]);
   Tcl_GetIntFromObj (tI, objv[7], &mBi[0]);
   Tcl_GetIntFromObj (tI, objv[8], &mBi[1]);

/* Get the array inputs                                                     */

   rC = (mAi[0] > mBi[0]) ? mAi[0] : mBi[0];
   cC = (mAi[1] > mBi[1]) ? mAi[1] : mBi[1];

   sA = mAi[0] * mAi[1];
   sB = mBi[0] * mBi[1];
   sC = rC * cC;

   Bytes = sizeof(ReaL_8) * (sA + sB + sC);
   if ((memPtr = malloc (Bytes)) == NULL)
      return TCL_ERROR;
   mA = (ReaL_8 *)memPtr;
   mB = mA + sA;
   mC = mB + sB;

   oP = Oper[0];

   if (oP != 'U') {
      if (TclArrayToC (tI, objv[1], (void *)mA, sA, mO[0], 'D') == 0) {
         free (memPtr);
         return TCL_OK;
      }
   }

   if (oP == '*') {
      if (TclArrayToC (tI, objv[3], (void *)mB, sB, mO[1], 'D') == 0) {
         free (memPtr);
         return TCL_OK;
      }
   }

/* Call the C routine                                                       */

   rN = MatrixMath_C (mA, oP, mB, mC, mAi, mBi);

/* Return the Resultant Array to a Tcl Array                                */

   CArrayToTcl (tI, objv[4], (void *)mC, rN, mO[2], 'D');

/* Get rid of the temporary arrays and return                               */ 

   free (memPtr);

   objPtr = Tcl_GetObjResult(tI);
   Tcl_SetDoubleObj (objPtr, (double)rV);

   return TCL_OK;
}


/* THE C ROUTINE                                                       */
/*                                                                     */
/*  In the C routine operations have character representations.  Some  */
/*  of the reductions from the Tcl Operations include:                 */
/*     'U':  UNIT                                                      */
/*     'T':  TRANSPOSE                                                 */
/*     '*':  MULTIPLY                                                  */

ByTe_4 MatrixMath_C (ReaL_8 *mA, ByTe_1 oP, ReaL_8 *mB, ReaL_8 *mC, 
                     int *mAi, int *mBi)
{
    register ByTe_4 I, J, K, L;
    ByTe_4 P = 0; 
    ByTe_4 EnD, aEnD, bEnD;

    switch (oP) {
      case 'U': 
         EnD = mAi[0] * mAi[1];
         for (I = 0, J = 0 ; I < EnD ; ++I ) { 
            if ( I == J ) {
	       mC[I] = 1.0;
	       J += mAi[0] + 1;
            } else { mC[I] = 0.0; }
         }
	 P = EnD;
      break;
      case 'T': 
         EnD = mAi[0] * mAi[1];
         for (I = 0, J = 0 ; I < EnD ; ++J ) { 
	    K = J;
            for (L = 0; L < mAi[1] ; ++L, ++I, K += mAi[0] ) { 
	       mC[K] = mA[I];
	    }
         }
	 P = EnD;
      break;
      case '*': 
         P = 0;
         aEnD = mAi[0] * mAi[1];
         bEnD = mBi[0] * mBi[1];
         EnD =  mBi[1];
         for (I = 0; I < aEnD ; I += mAi[1] ) { 
            for (J = 0; J < EnD ; ++J, ++P ) { 
	       mC[P] = 0.0;
	       L = I;
               for (K = J; K < bEnD ; ++L, K += mBi[1] ) { 
	          mC[P] += mA[L] * mB[K]; 
	       }
	    }
         }
      break;
    }

    return P;
}
