/*  The C equivalent of TUgeiGeo,  It consists of a TCL interface over      */
/*  a straight C subroutine                                                 */
/*                                                                          */
/*  There are 4 OBJV elements.  These are:                                  */
/*     OBJV[0]:  Routine name                                               */
/*     OBJV[1]:  The GEI vector (GeI)                                       */
/*     OBJV[2]:  The transfer information array (xInfo)                     */
/*           Index 0: Mean Julian Day (MjD)                                 */
/*           Index 1: Greenwich mean Siderial Time (GsT)                    */
/*           Index 2: cos(GsT)                                              */
/*           Index 3: sin(GsT)                                              */
/*     OBJV[3]:  The GeO vector (GeO)                                       */

#include <tcl.h>
#include <stdlib.h>
#include <math.h>
#include "ByteDefs.h"
#include "TutilAnsi.h"

int GeiToGeoCmd (ClientData cD, Tcl_Interp *tIntp, 
                                int objc, Tcl_Obj *CONST *objv) 
{
   void *memPtr = NULL; 
   ReaL_8 *GeO, *GeI, *xInfo;

   ByTe_4 Bytes, rV;

/* Make sure that all the IO parameters are present */

   if (objc != 4 ) {
     Tcl_WrongNumArgs(tIntp, 1, objv, "Usage: TUgeiGEO GEI XInfo GEO");
     return TCL_ERROR;
   }

/* Now lets to all the necessary mallocs at once                           */

   Bytes = 10 * sizeof(ReaL_8);
   if ((memPtr = malloc (Bytes)) == NULL)
     return TCL_ERROR;

/* OK now lets assign all the pointers into that malloc                   */

   GeI = (ReaL_8 *)memPtr; 
   GeO = (ReaL_8 *)memPtr + 3; 
   xInfo = (ReaL_8 *)memPtr + 3; 

/* Transfer array data from the TCL array to the C array                   */

   if (TclArrayToC (tIntp, objv[1], (void *)GeI, 3, 0, 'D') == 0) {
      free (memPtr);
      return TCL_OK;
   }
   if (TclArrayToC (tIntp, objv[2], (void *)xInfo, 4, 0, 'D') == 0) {
      free (memPtr);
      return TCL_OK;
   }

/* Call the C routine                                                       */

   rV =  GeiToGeo_C (GeI, xInfo, GeO);

/* Reconvert to the Grid and Norm C Arrays to Tcl Arrays                    */

   CArrayToTcl (tIntp, objv[3], GeO, 3, 0, 'D'); 

/* Get rid of the temporary array and return                                */

   free (memPtr);
   return TCL_OK;
}


/* THE C ROUTINE                                                            */


ByTe_4 GeiToGeo_C (ReaL_8 *GeI, ReaL_8 *xInfo, ReaL_8 *GeO)
{
    register ReaL_8 *fPt;

    fPt = GeO;
    *fPt++ = xInfo[2] * GeI[0] + xInfo[3] * GeI[1];
    *fPt++ = -xInfo[3] * GeI[0] + xInfo[2] * GeI[1];
    *fPt = GeI[2];

    return 1;
}
