/*  The C equivalent of TUdataRnd1,  It consists of a TCL interface over    */
/*  a straight C subroutine                                                 */
/*                                                                          */
/*  There are 8 OBJV elements.  These are:                                  */
/*     OBJV[0]:  Routine name                                               */
/*     OBJV[1]:  The data array (Data)                                      */
/*     OBJV[2]:  Number of data points (Np)                                 */
/*     OBJV[3]:  Return Range                                               */
/*     OBJV[4]:  Max value                                                  */

#include <tcl.h>
#include <stdlib.h>
#include <string.h>
#include "ByteDefs.h"
#include <TutilAnsi.h>

int DataRnd1Cmd (ClientData cD, Tcl_Interp *tI, 
                                int objc, Tcl_Obj *CONST *objv) 
{
   void *memPtr;
   ReaL_8 *V, MaX;
   int N, Bytes, Seed, rV;
   ByTe_1 *RnG;
   ByTe_2 rG;

   Tcl_Obj *objPtr, *rVO;
   int Flg = TCL_LEAVE_ERR_MSG | TCL_GLOBAL_ONLY;

/* Make sure that the minimum number of IO parameters are present */

   if (objc < 4 ) {
     Tcl_WrongNumArgs(tI, 1, objv, "Usage: TUdataRnd1 V nP RnG");
     return TCL_ERROR;
   }

/* Get the non-array input parameters                                      */

   Tcl_GetIntFromObj (tI, objv[2], &N);
   RnG = Tcl_GetStringFromObj(objv[3], (int *)0);
   if ( RnG[1] == 0 ) {
     rG = (RnG[0] == 'P') ? 0 : 1;
   } else { rG = 2; }
   if (objc >= 5) { 
      Tcl_GetDoubleFromObj (tI, objv[4], &MaX); 
   } else { MaX = 1.0; }

/* Get the array inputs                                                     */

   Bytes = sizeof(ReaL_8) * N;
   if ((memPtr = malloc (Bytes)) == NULL)
      return TCL_ERROR;
   V = (ReaL_8 *)memPtr;

/* GET the seed value */

   rV = Tcl_UpVar(tI, "#0", "Rnd1Seed", "rSeed", 0);
   if ( (rVO = Tcl_GetVar2Ex(tI, "rSeed", (char *)0, Flg)) == NULL) {
      Seed = 566378;
      rVO = Tcl_NewObj();
   } else { Tcl_GetIntFromObj (tI, rVO, &Seed); }

/* Call the  straight C array procedure                                   */

   Seed = DataRnd1_C (V, N, rG, MaX, Seed); 

/* Replace seed value */

   rVO = Tcl_DuplicateObj(rVO);
   Tcl_SetIntObj (rVO, Seed);
   Tcl_SetVar2Ex(tI, "rSeed", (char *)0, rVO, Flg);

/* Return the data array                                                  */

   CArrayToTcl (tI, objv[1], V, N, 0, 'D');

/* Return first random number and free data array                         */

   objPtr = Tcl_GetObjResult(tI);
   Tcl_SetDoubleObj (objPtr, V[0] ); 

   free (memPtr);
   return TCL_OK;
}

   
int  DataRnd1_C (ReaL_8 *V, int N, ByTe_2 rG, ReaL_8 MaX, int Seed) 
{

   ReaL_8 SgN;
   ByTe_4 I;

   switch (rG) {
      case 0:
         for (I = 0; I < N; ++I) {
	    Seed = (1027 * Seed) % 1048576;
            V[I] = MaX * Seed / 1048576.0;
         }
      break;
      case 1:
         for (I = 0; I < N; ++I) {
	    Seed = (1027 * Seed) % 1048576;
            V[I] = -MaX * Seed / 1048576.0;
         }
      break;
      case 2:
         for (I = 0; I < N; ++I) {
	    Seed = (1027 * Seed) % 1048576;
            V[I] = MaX * Seed / 1048576.0;
            Seed = (1027 * Seed) % 1048576;
            SgN = Seed / 1048576.0;
            if ( SgN < 0.5 ) { V[I] = -V[I]; }
         }
      break;
   }

   return(Seed);
}
