/*  The C equivalent of TUdataMxMn,  It consists of a TCL interface over    */
/*  a straight C subroutine                                                 */
/*                                                                          */
/*  There are 8 OBJV elements.  These are:                                  */
/*     OBJV[0]:  Routine name                                               */
/*     OBJV[1]:  The data array (Data)                                      */
/*     OBJV[2]:  Elements In Data Array (N)                                 */
/*     OBJV[3]:  The search condition (Equal)                               */
/*     OBJV[4]:  Exclude data below this limit (BotV)                       */
/*     OBJV[5]:  Exclude data above this limit (TopV)                       */
/*     OBJV[6]:  Skip Elements in data Loop (Skip)                          */
/*     OBJV[7]:  Start Here (Off)                                           */

#include <tcl.h>
#include <stdlib.h>
#include <string.h>
#include "ByteDefs.h"
#include <TutilAnsi.h>

int DataMxMnCmd (ClientData cD, Tcl_Interp *interp, 
                                int objc, Tcl_Obj *CONST *objv) 
{
   void *memPtr;
   ReaL_8 *V;
   ByTe_4 Bytes, Mn, Mx;

   int N, Skip = 1, Off = 0;
   ReaL_8 BotV = -9.0e30, TopV = 9.0e30;
   ByTe_1 *Cond, OuT[20];

   Tcl_Obj *objPtr;

/* Make sure that the minimum number of IO parameters are present */

   if (objc < 4 ) {
     Tcl_WrongNumArgs(interp, 1, objv, "Usage: TUdataMxMn Array Len Cond");
     return TCL_ERROR;
   }

/* Get the non-array input parameters                                      */

   Tcl_GetIntFromObj (interp, objv[2], &N);
   Cond = Tcl_GetString(objv[3]);
   if (strlen(Cond) == 2) { Cond[0] = 'G'; }
   if (objc >= 5)
     Tcl_GetDoubleFromObj (interp, objv[4], &BotV);
   if (objc >= 6)
      Tcl_GetDoubleFromObj (interp, objv[5], &TopV);
   if (objc >= 7)
      Tcl_GetIntFromObj (interp, objv[6], &Skip);
   if (objc >= 8)
      Tcl_GetIntFromObj (interp, objv[7], &Off);

/* Get the array inputs                                                     */

   Bytes = sizeof(ReaL_8) * N;
   if ((memPtr = malloc (Bytes)) == NULL)
      return TCL_ERROR;
   V = (ReaL_8 *)memPtr;

   if (TclArrayToC (interp, objv[1], (void *)V, N, Off, 'D') == 0) {
      free (memPtr);
      return TCL_OK;
   }
   
/* Call the  straight C array procedure                                   */

   DataMxMn_C (V, N, *Cond, BotV, TopV, Skip, &Mn, &Mx); 

/* Gather output - free data array - and gone                             */

   free (memPtr);

   switch (*Cond) {
      case '>':
         sprintf (OuT, "%d", Mx + Off);
      break;
      case '<':
         sprintf (OuT, "%d", Mn + Off);
      break;
      case 'G':
         sprintf (OuT, "%d %d", Mn + Off, Mx + Off);
      break;
   }


   objPtr = Tcl_GetObjResult(interp);
   Tcl_SetStringObj (objPtr, OuT, strlen(OuT)); 
   return TCL_OK;
}

   
void  DataMxMn_C (ReaL_8 *A, ByTe_4 N, ByTe_1 Cond, ReaL_8 BotV, ReaL_8 TopV, 
                  ByTe_4 Skip, ByTe_4 *Mn, ByTe_4 *Mx) 
{

   ReaL_8 VMx, VMn;
   ByTe_4 I, EnD;

   *Mx = -1;
   *Mn = -1;
   VMx = BotV;
   VMn = TopV;
   EnD = N;
   switch (Cond) {
      case '>':
         for (I = 0; I < EnD; I += Skip) {
            if ( (A[I] > VMx) && (A[I] < TopV)) { VMx = A[I]; *Mx = I; }
         }
      break;
      case '<':
         for (I = 0; I < EnD; I += Skip) {
            if ( (A[I] < VMn) && (A[I] > BotV)) { VMn = A[I]; *Mn = I; }
         }
      break;
      case 'G':
         for (I = 0; I < EnD; I += Skip) {
            if ( (A[I] < VMn) && (A[I] > BotV)) { VMn = A[I]; *Mn = I; }
            if ( (A[I] > VMx) && (A[I] < TopV)) { VMx = A[I]; *Mx = I; }
         }
      break;
   }
}
