/*  A Tcl/C utility routine which takes a C array and comverts it into       */
/*  a Tcl list.                                                              */

#include <tcl.h>
#include <stdlib.h>
#include <string.h>
#include "ByteDefs.h"

ByTe_4 CArrayToList (Tcl_Interp *tI, Tcl_Obj *V, void *aP, ByTe_4 N, ByTe_1 aSz) 
{
   register ReaL_8 *dPt;
   register ReaL_4 *fPt;
   register ByTe_4 *lPt, I;
   register ByTe_2 *sPt;
   register ByTe_1 *cPt;
   register u_ByTe_4 *ulPt;
   register u_ByTe_2 *usPt;
   register u_ByTe_1 *ucPt;

   void *memPtr;

   ByTe_4 Bytes;
   int    NewObj = 0, sLen;
   ByTe_1 *NamE;

   Tcl_Obj **lObj, *nObj, *noP;

   int Flg = TCL_LEAVE_ERR_MSG;

/* Malloc space for the list object pointers                */

   Bytes = N * sizeof(*lObj);
   if ((memPtr = malloc (Bytes)) == NULL) { return TCL_ERROR; }
   lObj = (Tcl_Obj **)memPtr;

/* Put the data into a an array or list objects C array      */

   switch (aSz) {
      case 'D':
        dPt = (ReaL_8 *)aP;
        for (I = 0; I < N; ++I) { lObj[I] = Tcl_NewDoubleObj(*dPt++); }
      break;
      case 'F':
        fPt = (ReaL_4 *)aP;
        for (I = 0; I < N; ++I) { lObj[I] = Tcl_NewDoubleObj((ReaL_8)*fPt++); }
      break;
      case 'L':
        lPt = (ByTe_4 *)aP;
        for (I = 0; I < N; ++I) { lObj[I] = Tcl_NewIntObj((int)*lPt++); }
      break;
      case 'S':
        sPt = (ByTe_2 *)aP;
        for (I = 0; I < N; ++I) { lObj[I] = Tcl_NewIntObj((int)*sPt++); }
      break;
      case 'C':
        cPt = (ByTe_1 *)aP;
        for (I = 0; I < N; ++I) { lObj[I] = Tcl_NewIntObj((int)*cPt++); }
      break;
      case 'l':
        ulPt = (u_ByTe_4 *)aP;
        for (I = 0; I < N; ++I) { lObj[I] = Tcl_NewIntObj((int)*ulPt++); }
      break;
      case 's':
        usPt = (u_ByTe_2 *)aP;
        for (I = 0; I < N; ++I) { lObj[I] = Tcl_NewIntObj((int)*usPt++); }
      break;
      case 'c':
        ucPt = (u_ByTe_1 *)aP;
        for (I = 0; I < N; ++I) { lObj[I] = Tcl_NewIntObj((int)*ucPt++); }
      break;
   }

   noP = Tcl_ObjGetVar2(tI, V, NULL, 0);
   if (noP == NULL) {
       NamE = Tcl_GetStringFromObj(V, &sLen);
       noP = Tcl_NewObj();
   } else if (Tcl_IsShared(noP)) {
       noP = Tcl_DuplicateObj(noP);
       NewObj = 1;
   }
   Tcl_SetListObj (noP, (int)N, lObj);
   nObj = Tcl_ObjSetVar2(tI, V, NULL, noP, Flg);

   if (memPtr != NULL) { free(memPtr); }

   return 1;
}
