#  THIS procedure returns a list of two lists.  The first is a set of the
#    VIDF sensor numbers requested and the second is their corresponding
#    PIDF sensor numbers.
#  INPUTS are:
#    KeY:  the udf key to use when getting the sensors
#    rF:   how the sensors are to be found
#          ALL SENSORS == 2
#          ALL SENSORS IN GROUP == 1
#          ONE SENSOR == 0
#    gP:   The PIDF group number
#    sN:   The PIDF base sensor number
#    uN:   The PIDF sensor unit number selected

package provide UDFUtils 1.0

proc UUgetSensors { KeY rF gP sN uN { LID 1 } } {
   global Pidf0

# BLANK out the sensor list

   set sNum ""
   set pNum ""

# GET the PIDF information

   ReadPIDF $KeY

# CHECK to see if the unit number has a non negative local_id

   if { $LID } { set lID [lindex $Pidf0(UnitLId) $uN] } else { set lID -1 }
   set aUN ""
   if { $lID >= 0 } {
      for { set I 0 } { $I < $Pidf0(NUnits) } { incr I } {  
         set iD [lindex $Pidf0(UnitLId) $I]
	 if { $lID == $iD } { lappend aUN $I }
      }
   } else { lappend aUN $uN }
   set nU [llength $aUN]

# IF rF is 2 get every sensor which has the same units as the base sensor
# IF rF is 1 get every sensor which has the same units as the base sensor and
#   is in the same group
# IF rF is 0 just echo back the sensor

   switch -exact -- $rF {
      2 {
         for { set I 0 } { $I < $Pidf0(NSens) } { incr I } {
            set aU [lindex $Pidf0(SenUnits) $I]
	    set J 0; set More 1
	    while { ($J < $nU) && $More } {
	       set sUN [lindex $aUN $J]
               if { [lsearch $aU $sUN] >= 0 } {
                  lappend sNum [lindex $Pidf0(SenVidfN) $I]
                  lappend pNum $I
		  set More 0
               }
	       incr J
            }
         }  
      }
      1 {
         for { set I 0 } { $I < $Pidf0(NSens) } { incr I } {
            if { [lindex $Pidf0(SenGrpN) $I] == $gP } {
               set aU [lindex $Pidf0(SenUnits) $I]
	       set J 0; set More 1
	       while { ($J < $nU) && $More } {
	          set sUN [lindex $aUN $J]
                  if { [lsearch $aU $sUN] >= 0 } {
                     lappend sNum [lindex $Pidf0(SenVidfN) $I]
                     lappend pNum $I
		     set More 0
                  }
	          incr J
               }
            }
         }  
      }  
      0 {
        set sNum [lindex $Pidf0(SenVidfN) $sN]
        set pNum $sN
      }
   }

   return [list $sNum $pNum]
}
