#  THIS procedure takes an ascii VIDF file and creates a binary version
#    of it.

package provide TclUDFdB 1.0

proc DBvidfToBinary { vName } {
  
#  ESTABLISH if this is a new style IDFS VIDF or an old style UDF/IDFS VIDF

   set vName [DBfileBname $vName]

   set vAscii  ${vName}V

#  OPEN file

   if [catch {open $vAscii r} fa ] {
      puts stderr "DBvidfToBinary:  CANNOT OPEN FILE $vAscii"
      return 0
   }

#  DETERMINE what the first field looks like

   gets $fa vLine
   close $fa
   set vLine [string trim $vLine]
   set First [string index $vLine 0]

# CALL the appropriate conversion procedure

   if { $First == "v" } {
      DBvidfConvertIDFS $vName
   } else { DBvidfConvertUDF $vName }
}
