#  THIS procedure parses a VIDF line from an ASCII file

package provide TclUDFdB 1.0

proc DBvidfLineParse { vLine } {
   global VFields VDeps VSize tcl_platform

# TRIM the line of all beginning and ending spaces

   set vLine [string trim $vLine]

# DOES the line contain a beginning and ending comment indicator.  If it 
#   does then strip the comment out of the line.

   set cBeG [string first "/*" $vLine]
   if { $cBeG >= 0 } {                           
      if { [string first "*/" $vLine] > 0 } {     
         set EnD [expr $cBeG - 1]
         if { $EnD < 0 } { return "" }
      } else { set EnD end }
   } else { set EnD end }

   set vLine [string range $vLine 0 $EnD] 

# GET the line type

   set vOut [string index $vLine 0]
   set vLine [string range $vLine 1 end] 

# DO a few more manipulations based on the line type,

   switch -exact -- $vOut {
     V  {  lappend vOut [string trim $vLine]                  }
     t  {  lappend vOut [string trimright $vLine]             }
     m  {  regexp {([0-9]*)[ \t]*([0-9]*)} [string trim $vLine] Tot M N  
           lappend vOut $M 
           lappend vOut $N 
        }
     b  -
     s  -
     l  {  set bC [string first "/*" $vLine]
           set eC [string first "*/" $vLine]
	   if { ($bC >= 0) || ($eC >= 0) } { 
              puts stderr "DBvidfLineParse $vLine" 
              puts stderr "   malformed comment." 
	   }
           set vLine [string trim $vLine]
           while { [string length $vLine] > 0 } {
              regexp {([\-0-9]*)[ \t]*(.*)} $vLine ToT V vLine
              lappend vOut $V
           }
        }
     T  {  set vLine [string trim $vLine]
           set SeP \"
           while { [string length $vLine] > 0 } {
              if { [string index $vLine 0] == $SeP } {
                 regexp {\"([^\"]*)\"[  \t]*(.*)} $vLine ToT V vLine
              } else { regexp {([^ ]*)[  \t]*(.*)} $vLine ToT V vLine }
              lappend vOut $V
           }
        }
   }
   return $vOut
}
