# THIS returns the vidf files associated with the input virtual file.  This 
#   is not a database search but a search simply on file name.
#
# INPUTS are:
#
#   vDir      - the directory to look in for the VIDF file(s)
#   vName     - UDF virtual name

package provide TclUDFdB 1.0

proc DBvidfFind { vDir vName } {
   global env tcl_platform SySCmDs 

# List the contents of the VIDF directory

   set vList [exec $SySCmDs(ls) $vDir]

# FIND all of the  VIDF files used by this virtual instrument.  The
#   lsearch returns all of the files which start with the virtual name.  

   set vLen [llength $vList]
   set PoS ""
   for { set I 0 } { $I < $vLen } { incr I } {
      if [string match ${vName}* [lindex $vList $I]] { lappend PoS $I }   
   }

   set Len [llength $PoS]
   set vReT ""
   if { $Len >= 0 } {
      for { set I 0 } { $I < $Len } { incr I } {
         set vF [lindex $vList [lindex $PoS $I]] 
         set vN [string range $vF 0 [expr [string length $vF] - 13]]
         if { [string compare $vName $vN] == 0 } { lappend vReT $vF }
      }
   } 

  return $vReT
}
