#  THIS procedure takes an bunch of structures and makes an array out
#    of one of the elements

package provide TclUDFdB 1.0

proc DBvidfCorIDFS { ViDf } {

   upvar $ViDf V

# CORECTION 1.  If there is a pitch angle structure defined take the
#     sensors which are defined separately and put them into a single
#     definition in the structure.

   if [info exists V(PitchAngle,b1)] {
       set V(PitchAngle,sensor) [list $V(PitchAngle,b1) \
                                      $V(PitchAngle,b2) \
                                      $V(PitchAngle,b3) ] 
   }

# CORRECTION 2. If there are CalSet definitions then we need to at a 
#      minimum correct for cases where the sensors are scalar and the
#      usage is 1.  This should be set to 0 which is what they intend
#      (I think).  The scope varaible somehow comes into this but there
#      is not documentation on this.

   if { $V(smp_id) == 2 } {
      set I 0
      while { [info exists V(CalSet$I,use)] } {
         if [info exists V(CalSet$I,scope)] {
            if { $V(CalSet$I,scope) == 1 } { set V(CalSet$I,target) 2 }
            if { $V(CalSet$I,target) == 0 } { set V(CalSet$I,target) 0 }
         }
         incr I
      }
   }

# CORRECTION 3. IF nano_defined is 1 then this is equivalent to a preface
#      ancillary data set.  Set it up as such.

   if  [info exists V(nano_defined)] {
      if { $V(nano_defined) == 1 } {
         if [info exists V(n_cal_sets)] {
              set N $V(n_cal_sets)
              incr V(n_cal_sets)
         } else {
              set N 0
              set V(n_cal_sets) 1
         }
         set V(CalSet$N,name) "\{NanoSecond Offset\}"
         set V(CalSet$N,use) 0
         set V(CalSet$N,target) 3
         set V(CalSet$N,word_len) 32
      }
   }
}
