#  THIS procedure takes an ascii VIDF file and creates a binary version
#    of it.

package provide TclUDFdB 1.0

proc DBvidfConvertUDF { vName } {
   global VFields VDeps VSize UDFdataOrder

# SET the VIDF field information lists

   UDFvidfInfo

# SET the platform integer format 

  if [string match littleEndian $UDFdataOrder] {
      set ByTe_2 s
      set ByTe_4 i
   } else {
      set ByTe_2 S
      set ByTe_4 I
   }
  
#  ESTABLISH the ascii and binary VIDF file names by adding the appropriate
#    ending to the generic file name passed in.

   set vAscii  ${vName}V
   set vBinary ${vName}I

#  OPEN both files

   if [catch {open $vAscii r} fa ] {
      puts stderr "DBvidfToBinary:  CANNOT OPEN FILE $vAscii"
      return 0
   }

   if [catch {open $vBinary w} fb ] {
      puts stderr "DBvidfToBinary:  CANNOT OPEN FILE $vBinary"
      return 0
   }
   fconfigure $fb -translation binary

#  Determine how many fields there are in the VIDF base fields section

   set nBF [lsearch -exact $VFields TBLSCASZ]  

# CHECK to see if there is a Version line in the VIDF.  If there isn't
#   a version line set it to and reset the ASCII file pointer to the 
#   start of the file.

   gets $fa vLine
   set vOuT [DBvidfLineParse $vLine]
   if { [lindex $vOuT 0] == "V" } {
      set VerS [binary format "a8" [format %-7s [lindex $vOuT 1]] ] 
   } else { 
      TUfileSeek $fa 0 start 
      set VerS [binary format "a8" "V2.1" ] 
   }

# LOOP through the base VIDF fields stopping at the start of the table
#   definitions

   set cP 0
   set Base ""
   for { set I 0 } { $I < $nBF } { incr I } { 
      lappend bOff $cP
      incr cP [DBvidfProcField $fa Base $ByTe_4 $ByTe_2 ]
   }

# FLUSH out the Offset list to the size of the VIDF field list

  set fLen [llength $VFields]
  lappend bOff $cP ; incr I
  for {  } { $I < $fLen } { incr I } { lappend bOff 0 }

# FIND is the number of table definitions in the VIDF and the number of
#   fields in a table definition

   set TbL [lsearch -exact $VFields NUMTBLS]
   set Off [lindex $bOff $TbL] 
   binary scan $Base @${Off}c nT
   set nTFields [ expr [lsearch -exact $VFields CONSTID] - $nBF] 

# LOOP through the base VIDF tables 

   for { set I 0 } { $I < $nT } { incr I } { 
     for { set J 0 } { $J < $nTFields } { incr J } { 
         lappend tOff $cP
         incr cP [DBvidfProcField $fa Base $ByTe_4 $ByTe_2 ]
      }
   }
   lappend tOff $cP 

   set CoN [lsearch -exact $VFields NUMCONSTS]
   set Off [lindex $bOff $CoN] 
   binary scan $Base @${Off}c nC
   set nCFields [ expr [lsearch -exact $VFields CONST] - \
                       [lsearch -exact $VFields CONSTID] + 1] 

   for { set I 0 } { $I < $nC } { incr I } { 
     for { set J 0 } { $J < $nCFields } { incr J } { 
         lappend cOff $cP
         incr cP [DBvidfProcField $fa Base $ByTe_4 $ByTe_2 ]
      }
   }
   lappend cOff $cP 

   puts -nonewline $fb $VerS
   set nO [llength $bOff]
   set bS [expr $nO * 4]
   puts -nonewline $fb [binary format "$ByTe_4" $bS]
   puts -nonewline $fb [binary format "$ByTe_4$nO" $bOff]
   puts -nonewline $fb [binary format "$ByTe_4" $nT]
   set nO [llength $tOff]
   set bS [expr $nO * 4]
   puts -nonewline $fb [binary format "$ByTe_4" $bS]
   puts -nonewline $fb [binary format "$ByTe_4$nO" $tOff]
   puts -nonewline $fb [binary format "$ByTe_4" $nC]
   set nO [llength $cOff]
   set bS [expr $nO * 4]
   puts -nonewline $fb [binary format "$ByTe_4" $bS]
   puts -nonewline $fb [binary format "$ByTe_4$nO" $cOff]
   set fS [string length $Base]
   puts -nonewline $fb [binary format "$ByTe_4" $fS]
   puts -nonewline $fb $Base

   close $fa
   close $fb

  return 1
}
