package provide TclUDFdB 1.0

proc DBtimesHD { dPath hdName vPath vName } {
   global SInfo ByTe_2 ByTe_4

# CHECK to see if the VIDF information arrays have been loaded.  If not
#   load them now

    if ![info exists ByTe_4] { UDFInits }

# INITIALIZE the return list

   set rL ""

#   NOTE: WE USE A DUMMY KEY.VER OF -1,0.  WE ARE NOT GOING THROUGH ALL OF 
#   THE FORMAL UDF LINEAGE AND SO CAN'T BUILD A REAL KEY 

   set kV -1,0

# OPEN the vidf file. Make sure this is not a base name and if it is then
#   expand it.

   set LastC [string index $vName end]
   if { $LastC != "I" } { set vName ${vName}I }

   set vN [file join $vPath $vName]
   if [catch {open $vN r} SInfo($kV,VFD)] {
      puts stderr "CANNOT OPEN $vN"
      return -1
   }

# READ in the vidf information 

   UDFvidfInit $kV

# OK - get the necessary VIDF fields and their derivitives

   UDFvidfFld $kV DATALEN 0 0 0 SInfo($kV,DLEN) 0
   UDFvidfFld $kV MAXNSS 0 0 0 SInfo($kV,GN,MAXNSS) 0
   UDFvidfFld $kV MAXNSS 0 0 0 SInfo($kV,GN,MAXNSS) 0
   set SInfo($kV,PT,TONSS)  [expr 4 * $SInfo($kV,GN,MAXNSS) + 12]

# GET the VIDF fields needed in computing the duration of a sensor set

   UDFvidfFld $kV SMPID 0 0 0 smpID 0
   UDFvidfFld $kV SWPLEN 0 0 0 mArray 0
   UDFvidfFld $kV SENMODE 0 0 0 tMode 0
   UDFvidfFld $kV DAMETHOD 0 0 0 aMode 0

# GET the header and data file names.  The procedure wants the base name but
#   a check is made in case a full header or data file name has been input
  
   set bName [DBfileBname $hdName]

# OPEN the HEADER and DATA files.

   set hN [file join $dPath $bName]H
   if [catch {open $hN r} SInfo($kV,HFD)] {
      puts stderr "CANNOT OPEN $hN"
      return -1
   }
   fconfigure $SInfo($kV,HFD) -translation binary

   set dN [file join $dPath $bName]D
   if [catch {open $dN r} SInfo($kV,DFD)] {
      puts stderr "CANNOT OPEN $dN"
      return -1
   }
   fconfigure $SInfo($kV,DFD) -translation binary

# READ the first six bytes of the first header record. This provides the 
#   the starting year and day. 

   set SInfo($kV,HEADER) [read $SInfo($kV,HFD) 6]
   binary scan $SInfo($kV,HEADER) @2$ByTe_2 sYr 
   binary scan $SInfo($kV,HEADER) @4$ByTe_2 sDy  

# READ the first four bytes of the first data record and get the starting 
#   milliseconds.

   set DaTa [read $SInfo($kV,DFD) 4]
   binary scan $DaTa $ByTe_4 sMs 

# CONVERT the starting times to Hr Mn Sc and microseconds.

   set sHr [expr int($sMs / 3600000)]
   set sMn [expr int(($sMs % 3600000) / 60000)]
   set sSc [expr int($sMs % 60000) / 1000]
   set sUs [expr ($sMs % 1000) * 1000]

# REWIND the header and data files

   TUfileSeek $SInfo($kV,HFD) 0 start
   TUfileSeek $SInfo($kV,DFD) 0 start

# GET the data file size.

   set dSize [file size $dN]

# DETERMINE the number of data records in the file and the number of bytes
#   to the start of the last full data record.

   set nRec   [expr int($dSize / $SInfo($kV,DLEN))]
   set nBytes [expr ($nRec - 1) * $SInfo($kV,DLEN)]

# GET to and read that last record

   TUfileSeek $SInfo($kV,DFD) $nBytes start
   set DaTa [read $SInfo($kV,DFD) $SInfo($kV,DLEN)]

# LOOK at the first header offset.  If this value is less than 0 then this
#   record is just an EOF record and we need to get the record before this.

   binary scan $DaTa @12$ByTe_4 hOff 
   if { $hOff < 0 } {
      set nBytes [expr ($nRec - 2) * $SInfo($kV,DLEN)]
      TUfileSeek $SInfo($kV,DFD) $nBytes start
      set DaTa [read $SInfo($kV,DFD) $SInfo($kV,DLEN)]
   }
   binary scan $DaTa $ByTe_4 eMs 

# GET the number of sensor sets in this data record

   set nBytes [expr 12 + 4 * $SInfo($kV,GN,MAXNSS)]
   binary scan $DaTa @$nBytes$ByTe_4  nSS
   if { $nSS < 0 } {
      set nSS [expr -$nSS]
      set Adv 0
   } else { set Adv 4 }

# LOOP over the number of defined sensor sets in the data record to compute
#   the time span covered.  

   set NS 0
   set ToHoff 12
   set cOff -100
   for { set I 0 } { $I < $nSS } { incr I } {
      binary scan $DaTa @$ToHoff$ByTe_4 hOff
      if { $hOff != $cOff } {
         TUfileSeek $SInfo($kV,HFD) $hOff start
         set HdR [read $SInfo($kV,HFD) 2]
         binary scan $HdR $ByTe_2 hSize 
         set HdR [read $SInfo($kV,HFD) $hSize]
         binary scan $HdR $ByTe_2$ByTe_2 eYr eDy  
         set tM [DBtimeSS $HdR $smpID $tMode $mArray $aMode] 
      }
      set eMs [expr $eMs + [lindex $tM 0]]
      set NS [expr $NS + [lindex $tM 1]]
      set eMs [expr $eMs + int($NS / 1000000)]
      set NS [expr $NS % 1000000]
   }
   set eDy [expr $eDy + int($eMs / 86400000)]
   set eMs [expr $eMs % 86400000]
   if { $eDy > [TUyearLeap $eYr] } {
      set eDy 1
      incr eYr
   }
   
# CONVERT the ending times to Hr Mn S and microsecondsc

   set eHr [expr int($eMs / 3600000)]
   set eMn [expr int(($eMs % 3600000) / 60000)]
   set eSc [expr int($eMs % 60000) / 1000]
   set eUs [expr ($eMs % 1000) * 1000]

   set rL [list $sYr $sDy $sHr $sMn $sSc $sUs $sMs \
                $eYr $eDy $eHr $eMn $eSc $eUs $eMs ]

   close $SInfo($kV,VFD)
   close $SInfo($kV,HFD)
   close $SInfo($kV,DFD)
   UDFunsetSInfo -1,0
   return $rL
}
