#  THIS procedure takes an ascii VIDF file and pulls out the start and
#     stop times

package provide TclUDFdB 1.0

proc DBtimesAVIDF { vD vName } {

#  Form the fill path name to the file

   if { [string index $vName end] != "V" } { append vName V }
   set vName [file join $vD $vName]

#  OPEN the file

   if [catch {open $vName r} fa ] {
      puts stderr "DBtimesAVIDF:  CANNOT OPEN FILE $vName"
      return 0
   }

# CHECK to see if there is a Version line in the VIDF.  If there isn't
#   a version line reset the ASCII file pointer to the  start of the file.

   gets $fa vLine
   set vOuT [DBvidfLineParse $vLine]
   if { [lindex $vOuT 0] != "V" } { TUfileSeek $fa 0 start }

# LOOP through the fields through the timing information definitions.  The
#   timing information fields are fields 7 thru 14.

   for { set J -7 ; set I 0 } { $I < 15  } { incr I ; incr J } { 
      gets $fa vLine
      set vOuT [DBvidfLineParse $vLine]

      if { $J >= 0 } { set Tm($J) [lindex $vOuT 1] }

# IF this is an array field then we need to know how many lines of VIDF
#   entries it occupies so we can skip it.

      if { [lindex $vOuT 0] == "m" } {
         set v0 [TUdataNoOctal [lindex $vOuT 1]]
         set v1 [TUdataNoOctal [lindex $vOuT 2]]
         set nLines [expr int($v0 / $v1)]
         if { [expr $v0 % $v1] > 0 } { incr nLines }
         set K 0
         while { $K < $nLines } {
            gets $fa vLine
            set vOuT [DBvidfLineParse $vLine]
            incr K
         }
      } 
   }

   close $fa

# FORM out put times

   set sHr [expr int($Tm(2) / 3600000)]
   set sMn [expr int(($Tm(2) % 3600000) / 60000)]
   set sSc [expr int($Tm(2) % 60000) / 1000]
   set sUs [expr ($Tm(2) % 1000) * 1000]
   set eHr [expr int($Tm(6) / 3600000)]
   set eMn [expr int(($Tm(6) % 3600000) / 60000)]
   set eSc [expr int($Tm(6) % 60000) / 1000]
   set eUs [expr ($Tm(6) % 1000) * 1000]
                                                                                
  set rL [list $Tm(0) $Tm(1) $sHr $sMn $sSc $sUs $Tm(2) \
               $Tm(4) $Tm(5) $eHr $eMn $eSc $eUs $Tm(6) ]
                                                                                
  return $rL
}
