# THIS procedure computes the time spanned by a sensor set
#
# INPUTS:
#
#   HdR    - the current header record
#   smpID  - sample iD
#   tMode  - measurement time mode
#   mArray - maximum number of array elements
#   aMode  - array element timing

package provide TclUDFdB 1.0

proc DBtimeSS { HdR smpID tMode mArray aMode } {
   global ByTe_2 ByTe_4

#  GET all of the timing information from the current header
#    YEAR/DAY

   binary scan $HdR ${ByTe_2}2 tM  
   set Yr [lindex $tM 0]
   set Dy [lindex $tM 1]

# SCALING parameter used to get accumulation time to seconds 

   binary scan $HdR @4c TSca  

# GET the measurement timing components

   binary scan $HdR @6${ByTe_4}4 tM  

   set Ms [expr 1000.0 * [lindex $tM 0] * pow (10.0, $TSca)]

   set accMS   [expr int($Ms) ]
   set accNS   [expr int(fmod ($Ms, 1) * 1000000.0) ]
   set latMS   [expr [lindex $tM 1] / 1000]
   set latNS   [expr ([lindex $tM 1] % 1000) * 1000]
   set srstMS  [expr [lindex $tM 2] / 1000]
   set srstNS  [expr ([lindex $tM 2] % 1000) * 1000]
   set ssrtsMS [expr [lindex $tM 3] / 1000]
   set ssrtsNS [expr ([lindex $tM 3] % 1000) * 1000]

# COMPUTE time between two consecutive measurements

   set smpMS [expr $accMS + $latMS]
   set smpNS [expr $accNS + $latNS]

# TOTAL number of effective columns of data in the sensor set matrix

   binary scan $HdR @22$ByTe_2 nS

   if { $smpID == 3 } {
      binary scan $HdR @30$ByTe_2 nC
      set nS [expr $nS * $nC]
      set ToaI 32
   } else { set ToaI 26 }

# TOTAL number of scalars per column or the array length.  Also the array
#  indices.

   if { $smpID != 2 } {
     binary scan $HdR @24$ByTe_2 nR
     binary scan $HdR @$ToaI${ByTe_2}$nR aI
   } else {
     set nR 1
     set aI 0
   }

# COMPUTE up time between consecutive measurements in the same data column

   set trC [expr 1 - $tMode / 4]
   set trP [expr 1 - (($tMode % 4) / 2)]
   set tcP [expr 1 - ($tMode % 2)]
   set drC [expr 1 - $trC]
   set drP [expr 1 - $trP]
   set dcP [expr 1 - $tcP]

   set colMS [expr $tcP * ($tcP * $smpMS + $drC * \
                        (($nS * $trP + $drP) * $smpMS + $srstMS))]

   set colNS [expr $tcP * ($tcP * $smpNS + $drC * \
                        (($nS * $trP + $drP) * $smpNS + $srstNS))]

# COMPUTE up time between consecutive measurements in the same data row

   set rowMS [expr $trP * ($drC * $smpMS + $tcP * \
                        (($nR * $tcP + $dcP) * $smpMS \ + $srstMS))]

   set rowNS [expr $trP * ($drC * $smpNS + $tcP * \
                        (($nR * $tcP + $dcP) * $smpNS \ + $srstNS))]

# COMPUTE an effective array length based on the array timing

   if { ($nR != 1) && ($smpID != 2) } {
      if { $aMode == 3 } {
         set nR [expr abs([lindex $aI 1] - [lindex $aI 0]) * $nR]
      } elseif { $aMode == 1 } {
         set nR $mArray 
      } elseif { $aMode == 2 } {
         set lRow [expr $nR - 1 ]
         set nR [expr abs([lindex $aI $lRow] - [lindex $aI 0]) + 1]
      }
   }   

   set lC [expr $nS - 1]
   set lR [expr $nR - 1]

   set totMS [expr $rowMS * $lC + $colMS * $lR  + $srstMS + $ssrtsMS + $smpMS]
   set totNS [expr $rowNS * $lC + $colNS * $lR  + $srstNS + $ssrtsNS + $smpNS]

   return [list $totMS $totNS]
}
