# SWAP the header bytes from big endian to little endian or vice versa.
#
# INPUTS:
#   HdR:   UDF Header file
#   vInfo: VIDF info needed in the swap process
#   ibF:   Input byte format
#          L - little endian      
#          B - big endian      
#   obF:   Input byte format
#          L - little endian      
#          B - big endian      

package provide TclUDFdB 1.0

proc DBswapHeader { HdR vInfo iBf oBf } {
   global env 

   upvar $vInfo vI

# SET the input and output write formats

   if { $iBf == "L" } {
      set iB4 i ; set iB2 s
   } else { set iB4 I ; set iB2 S }

   if { $oBf == "L" } {
      set oB4 i ; set oB2 s
   } else { set oB4 I ; set oB2 S }

# OPEN the header file as read/write

   if [catch {open $HdR r+} fd] {
      puts stderr "DBswapHeader: Can't Open $HdR"
      return -1
   }
   fconfigure $fd -translation binary

# GET the file size.  Need this to know when the file has been processed.

   set fS [file size $HdR]

# INITIALIZE the current byte position in the file

   set cP 0

# LOOP over the the file header record by header record

   while { [tell $fd] < $fS } {

# INITIALIZE the relative byte position in the header record

      set rP 0

# CONVERT the file size

      binary scan [read $fd 2] $iB2 hSize
      seek $fd -2 current
      puts -nonewline $fd [binary format $oB2 $hSize]
      incr cP 2
      seek $fd $cP start

# CONVERT the YEAR/DAY 
#   REMEMBER TO SKIP the 2 bytes of STATUS ANDTIMEBASE Informations.  That's
#   why its cP += 6 and not 4!

      binary scan [read $fd 4] ${iB2}2 TmP
      seek $fd -4 current
      puts -nonewline $fd [binary format ${oB2}2 $TmP]
      incr cP 6
      seek $fd $cP start

# CONVERT the ACCUM/LAT/SCAN/SENSOR SET times

      binary scan [read $fd 16] ${iB4}4 TmP
      seek $fd -16 current
      puts -nonewline $fd [binary format ${oB4}4 $TmP]
      incr cP 16
      seek $fd $cP start

# CONVERT the NUMBER of SENSORS and SAMPLES fields

      binary scan [read $fd 4] ${iB2}${iB2} nSen nSmp
      seek $fd -4 current
      puts -nonewline $fd [binary format ${oB2}${oB2} $nSen $nSmp]
      incr cP 4
      seek $fd $cP start

      incr rP 28

# IF UDF has matrix data convert the three matrix infomation fields

      if { $vI(SmpId) == 3 } {
         binary scan [read $fd 6] ${iB2}3 TmP
         seek $fd -6 current
         puts -nonewline $fd [binary format ${oB2}3 $TmP]
         incr cP 6
         incr rP 6
         seek $fd $cP start
      }

# IF UDF has scalar data there is only one scan index value

      if { $vI(SmpId) == 2 } { set nSmp 1 }

# CONVERT the SCAN and SENSOR index arrays

      set N [expr $nSmp  + $nSen]
      set B [expr 2 * $N]
      binary scan [read $fd $B] ${iB2}$N TmP
      seek $fd [expr -$B] current
      puts -nonewline $fd [binary format ${oB2}$N $TmP]
      incr rP $B

# REST of the data is byte data and doesn't get converted. Just skip it.

      incr B  [expr $hSize  - $rP]
      incr cP $B
      seek $fd $cP start
   }

   close $fd
}
