#  THIS procedure opens an NDX database file and reads the header information.

package provide TclUDFdB 1.0

proc DBndxOpen { ndX  nXInfo { Virtual "" } { openAs r } } {
   global NDXNumRecs NDXNumFlds NDXFldNames NDXFldTypes NDXFldLens \
          NDXKey NDXPos

   upvar $nXInfo nX

# LENGTH of the virtual instrument acronym.  A length of 0 means that no
#    virtual was specified

   set vLen [string length $Virtual]

# OPEN the NDX file as  a binary file. 
#
#  NOTE there appears to be a problem in Tcl>8.4.11 with a+ opens and 
#     possibly a opens.  I have implemented a workaround here.

   if [ file exists $ndX ] {
      switch -exact -- $openAs {
         a  -
         a+ {
            if [catch {open $ndX r+} nX(fd) ] {
               puts stderr "DBndxOpen:  CANNOT OPEN FILE $ndX"
               return 0
            }
	 }
         default {
            if [catch {open $ndX $openAs} nX(fd) ] {
               puts stderr "DBndxOpen:  CANNOT OPEN FILE $ndX"
               return 0
            }
         }
      }
   } else { puts stderr "NO DATABASE FILE $ndX" ; return 0 }
 
   seek $nX(fd) 0 start
   fconfigure $nX(fd) -translation binary

# READ the header block and pull out the number of records and fields

   set nX(Head) [read $nX(fd) 96]

# USE the number of fields to determine the file format

   binary scan $nX(Head) "@4I" nX(NextRec) 
   binary scan $nX(Head) "@8I" nX(NumRecs) 
   binary scan $nX(Head) "@12I" nX(NumFlds) 

   if { $nX(NumFlds) > 63000 } {
      set nX(bFmt) i
      binary scan $nX(Head) "@4i" nX(NextRec) 
      binary scan $nX(Head) "@8i" nX(NumRecs) 
      binary scan $nX(Head) "@12i" nX(NumFlds) 
   } else { set nX(bFmt) I }

#  Get the record size in bytes.  Records are padded to be an integral
#     number of 4 byte fields 

   set nX(KeyLen) 0
   set nX(FldNames) ""
   set nX(FldTypes) ""
   set nX(FldLens) ""
   for { set I 0 } { $I < $nX(NumFlds) } { incr I } {
      set InSet [expr $I * 16 + 16]
      binary scan $nX(Head) @${InSet}a10 NamE 
      lappend nX(FldNames) $NamE
      set InSet [expr $I * 16 + 26]
      binary scan $nX(Head) @${InSet}ac Type Len 
      lappend nX(FldTypes) $Type
      lappend nX(FldLens) $Len
      set nX(KeyLen) [expr $nX(KeyLen) + $Len]
   }

# PARSE through the NDX file.  If we are looking only for the positions of
#    a specific virtual then only gather that information otherwise get it
#    all

   set Extra ""
   set nX(Key) ""
   set nX(Pos) ""
   set nX(Pad) [expr (4 - ( $nX(KeyLen) % 4 )) % 4]
   set nX(RecLen) [expr $nX(KeyLen) + 4 + $nX(Pad)]
   for { set I 0 } { $I < $nX(NumRecs) } { incr I } {
      set Rec [read $nX(fd) $nX(RecLen)]
      if { $nX(Pad) != 0 } {
          binary scan $Rec a${nX(KeyLen)}c${nX(Pad)}${nX(bFmt)} Key Extra Pos
      } else { binary scan $Rec a${nX(KeyLen)}${nX(bFmt)} Key Pos }

      if { $Pos == 0 } { break }

      if { $vLen > 0 } {
         set vName [string trim [string range $Key 0 7]]
         if [string match $vName $Virtual] {
            lappend nX(Key) $Key
            lappend nX(Pos) $Pos
         }
      } else {
         lappend nX(Key) $Key
         lappend nX(Pos) $Pos
      }
   }
}
